/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.rpcv2.internal;

import java.io.IOException;
import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.json.SdkJsonGenerator;
import software.amazon.awssdk.protocols.json.StructuredJsonGenerator;
import software.amazon.awssdk.thirdparty.jackson.core.JsonFactory;
import software.amazon.awssdk.thirdparty.jackson.dataformat.cbor.CBORGenerator;

@SdkInternalApi
public final class SdkRpcV2CborGenerator
extends SdkJsonGenerator {
    private static final int CBOR_TAG_TIMESTAMP = 1;

    SdkRpcV2CborGenerator(JsonFactory factory, String contentType) {
        super(factory, contentType);
    }

    public StructuredJsonGenerator writeValue(Instant instant) {
        CBORGenerator generator = this.getGenerator();
        try {
            generator.writeTag(1);
            generator.writeNumber((double)instant.toEpochMilli() / 1000.0);
        }
        catch (IOException e) {
            throw new SdkJsonGenerator.JsonGenerationException((Throwable)e);
        }
        return this;
    }

    public StructuredJsonGenerator writeStartArray(int size) {
        CBORGenerator generator = this.getGenerator();
        try {
            generator.writeStartArray(null, size);
        }
        catch (IOException e) {
            throw new SdkJsonGenerator.JsonGenerationException((Throwable)e);
        }
        return this;
    }

    public StructuredJsonGenerator writeValue(double val) {
        if (SdkRpcV2CborGenerator.canConvertToLong(val)) {
            return this.writeValue((long)val);
        }
        CBORGenerator generator = this.getGenerator();
        try {
            generator.writeNumber(val);
        }
        catch (IOException e) {
            throw new SdkJsonGenerator.JsonGenerationException((Throwable)e);
        }
        return this;
    }

    public StructuredJsonGenerator writeValue(float val) {
        if (SdkRpcV2CborGenerator.canConvertToLong(val)) {
            return this.writeValue((long)val);
        }
        CBORGenerator generator = this.getGenerator();
        try {
            generator.writeNumber(val);
        }
        catch (IOException e) {
            throw new SdkJsonGenerator.JsonGenerationException((Throwable)e);
        }
        return this;
    }

    protected CBORGenerator getGenerator() {
        return (CBORGenerator)super.getGenerator();
    }

    private static boolean canConvertToLong(double value) {
        return (double)((long)value) == value && value >= -9.223372036854776E18 && value <= 9.223372036854776E18;
    }

    private static boolean canConvertToLong(float value) {
        return (float)((long)value) == value && value >= -9.223372E18f && value <= 9.223372E18f;
    }
}

