/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.simspaceweaver.model.LaunchCommandListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchOverrides
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchOverrides> {
    private static final SdkField<List<String>> LAUNCH_COMMANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchCommands").getter(LaunchOverrides.getter(LaunchOverrides::launchCommands)).setter(LaunchOverrides.setter(Builder::launchCommands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchCommands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_COMMANDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchOverrides.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> launchCommands;

    private LaunchOverrides(BuilderImpl builder) {
        this.launchCommands = builder.launchCommands;
    }

    public final boolean hasLaunchCommands() {
        return this.launchCommands != null && !(this.launchCommands instanceof SdkAutoConstructList);
    }

    public final List<String> launchCommands() {
        return this.launchCommands;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchCommands() ? this.launchCommands() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchOverrides)) {
            return false;
        }
        LaunchOverrides other = (LaunchOverrides)obj;
        return this.hasLaunchCommands() == other.hasLaunchCommands() && Objects.equals(this.launchCommands(), other.launchCommands());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchOverrides").add("LaunchCommands", this.hasLaunchCommands() ? this.launchCommands() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchCommands": {
                return Optional.ofNullable(clazz.cast(this.launchCommands()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("LaunchCommands", LAUNCH_COMMANDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchOverrides, T> g) {
        return obj -> g.apply((LaunchOverrides)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> launchCommands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchOverrides model) {
            this.launchCommands(model.launchCommands);
        }

        public final Collection<String> getLaunchCommands() {
            if (this.launchCommands instanceof SdkAutoConstructList) {
                return null;
            }
            return this.launchCommands;
        }

        public final void setLaunchCommands(Collection<String> launchCommands) {
            this.launchCommands = LaunchCommandListCopier.copy(launchCommands);
        }

        @Override
        public final Builder launchCommands(Collection<String> launchCommands) {
            this.launchCommands = LaunchCommandListCopier.copy(launchCommands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchCommands(String ... launchCommands) {
            this.launchCommands(Arrays.asList(launchCommands));
            return this;
        }

        public LaunchOverrides build() {
            return new LaunchOverrides(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchOverrides> {
        public Builder launchCommands(Collection<String> var1);

        public Builder launchCommands(String ... var1);
    }
}

