/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LifecycleManagementStrategy {
    UNKNOWN("Unknown"),
    PER_WORKER("PerWorker"),
    BY_SPATIAL_SUBDIVISION("BySpatialSubdivision"),
    BY_REQUEST("ByRequest"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LifecycleManagementStrategy> VALUE_MAP;
    private final String value;

    private LifecycleManagementStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LifecycleManagementStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LifecycleManagementStrategy> knownValues() {
        EnumSet<LifecycleManagementStrategy> knownValues = EnumSet.allOf(LifecycleManagementStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LifecycleManagementStrategy.class, LifecycleManagementStrategy::toString);
    }
}

