/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sfn.SfnAsyncClient;
import software.amazon.awssdk.services.sfn.internal.UserAgentUtils;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineListItem;

public class ListStateMachinesPublisher
implements SdkPublisher<ListStateMachinesResponse> {
    private final SfnAsyncClient client;
    private final ListStateMachinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStateMachinesPublisher(SfnAsyncClient client, ListStateMachinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStateMachinesPublisher(SfnAsyncClient client, ListStateMachinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStateMachinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStateMachinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StateMachineListItem> stateMachines() {
        return this.flatMapIterable(response -> response.stateMachines());
    }

    private class ListStateMachinesResponseFetcher
    implements AsyncPageFetcher<ListStateMachinesResponse> {
        private ListStateMachinesResponseFetcher() {
        }

        public boolean hasNextPage(ListStateMachinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStateMachinesResponse> nextPage(ListStateMachinesResponse previousPage) {
            if (previousPage == null) {
                return ListStateMachinesPublisher.this.client.listStateMachines(ListStateMachinesPublisher.this.firstRequest);
            }
            return ListStateMachinesPublisher.this.client.listStateMachines((ListStateMachinesRequest)((Object)ListStateMachinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

