/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StateMachineType {
    STANDARD("STANDARD"),
    EXPRESS("EXPRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StateMachineType> VALUE_MAP;
    private final String value;

    private StateMachineType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StateMachineType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StateMachineType> knownValues() {
        EnumSet<StateMachineType> knownValues = EnumSet.allOf(StateMachineType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StateMachineType.class, StateMachineType::toString);
    }
}

