/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMapRunRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, UpdateMapRunRequest> {
    private static final SdkField<String> MAP_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mapRunArn").getter(UpdateMapRunRequest.getter(UpdateMapRunRequest::mapRunArn)).setter(UpdateMapRunRequest.setter(Builder::mapRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapRunArn").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxConcurrency").getter(UpdateMapRunRequest.getter(UpdateMapRunRequest::maxConcurrency)).setter(UpdateMapRunRequest.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConcurrency").build()}).build();
    private static final SdkField<Float> TOLERATED_FAILURE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("toleratedFailurePercentage").getter(UpdateMapRunRequest.getter(UpdateMapRunRequest::toleratedFailurePercentage)).setter(UpdateMapRunRequest.setter(Builder::toleratedFailurePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toleratedFailurePercentage").build()}).build();
    private static final SdkField<Long> TOLERATED_FAILURE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("toleratedFailureCount").getter(UpdateMapRunRequest.getter(UpdateMapRunRequest::toleratedFailureCount)).setter(UpdateMapRunRequest.setter(Builder::toleratedFailureCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toleratedFailureCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_RUN_ARN_FIELD, MAX_CONCURRENCY_FIELD, TOLERATED_FAILURE_PERCENTAGE_FIELD, TOLERATED_FAILURE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMapRunRequest.memberNameToFieldInitializer();
    private final String mapRunArn;
    private final Integer maxConcurrency;
    private final Float toleratedFailurePercentage;
    private final Long toleratedFailureCount;

    private UpdateMapRunRequest(BuilderImpl builder) {
        super(builder);
        this.mapRunArn = builder.mapRunArn;
        this.maxConcurrency = builder.maxConcurrency;
        this.toleratedFailurePercentage = builder.toleratedFailurePercentage;
        this.toleratedFailureCount = builder.toleratedFailureCount;
    }

    public final String mapRunArn() {
        return this.mapRunArn;
    }

    public final Integer maxConcurrency() {
        return this.maxConcurrency;
    }

    public final Float toleratedFailurePercentage() {
        return this.toleratedFailurePercentage;
    }

    public final Long toleratedFailureCount() {
        return this.toleratedFailureCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mapRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.toleratedFailurePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.toleratedFailureCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMapRunRequest)) {
            return false;
        }
        UpdateMapRunRequest other = (UpdateMapRunRequest)((Object)obj);
        return Objects.equals(this.mapRunArn(), other.mapRunArn()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.toleratedFailurePercentage(), other.toleratedFailurePercentage()) && Objects.equals(this.toleratedFailureCount(), other.toleratedFailureCount());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMapRunRequest").add("MapRunArn", (Object)this.mapRunArn()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("ToleratedFailurePercentage", (Object)this.toleratedFailurePercentage()).add("ToleratedFailureCount", (Object)this.toleratedFailureCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mapRunArn": {
                return Optional.ofNullable(clazz.cast(this.mapRunArn()));
            }
            case "maxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "toleratedFailurePercentage": {
                return Optional.ofNullable(clazz.cast(this.toleratedFailurePercentage()));
            }
            case "toleratedFailureCount": {
                return Optional.ofNullable(clazz.cast(this.toleratedFailureCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mapRunArn", MAP_RUN_ARN_FIELD);
        map.put("maxConcurrency", MAX_CONCURRENCY_FIELD);
        map.put("toleratedFailurePercentage", TOLERATED_FAILURE_PERCENTAGE_FIELD);
        map.put("toleratedFailureCount", TOLERATED_FAILURE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMapRunRequest, T> g) {
        return obj -> g.apply((UpdateMapRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String mapRunArn;
        private Integer maxConcurrency;
        private Float toleratedFailurePercentage;
        private Long toleratedFailureCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMapRunRequest model) {
            super(model);
            this.mapRunArn(model.mapRunArn);
            this.maxConcurrency(model.maxConcurrency);
            this.toleratedFailurePercentage(model.toleratedFailurePercentage);
            this.toleratedFailureCount(model.toleratedFailureCount);
        }

        public final String getMapRunArn() {
            return this.mapRunArn;
        }

        public final void setMapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
        }

        @Override
        public final Builder mapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
            return this;
        }

        public final Integer getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final Float getToleratedFailurePercentage() {
            return this.toleratedFailurePercentage;
        }

        public final void setToleratedFailurePercentage(Float toleratedFailurePercentage) {
            this.toleratedFailurePercentage = toleratedFailurePercentage;
        }

        @Override
        public final Builder toleratedFailurePercentage(Float toleratedFailurePercentage) {
            this.toleratedFailurePercentage = toleratedFailurePercentage;
            return this;
        }

        public final Long getToleratedFailureCount() {
            return this.toleratedFailureCount;
        }

        public final void setToleratedFailureCount(Long toleratedFailureCount) {
            this.toleratedFailureCount = toleratedFailureCount;
        }

        @Override
        public final Builder toleratedFailureCount(Long toleratedFailureCount) {
            this.toleratedFailureCount = toleratedFailureCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMapRunRequest build() {
            return new UpdateMapRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMapRunRequest> {
        public Builder mapRunArn(String var1);

        public Builder maxConcurrency(Integer var1);

        public Builder toleratedFailurePercentage(Float var1);

        public Builder toleratedFailureCount(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

