/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStateMachineRequest extends SfnRequest implements
        ToCopyableBuilder<DescribeStateMachineRequest.Builder, DescribeStateMachineRequest> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineArn").getter(getter(DescribeStateMachineRequest::stateMachineArn))
            .setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()).build();

    private static final SdkField<String> INCLUDED_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("includedData").getter(getter(DescribeStateMachineRequest::includedDataAsString))
            .setter(setter(Builder::includedData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includedData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD,
            INCLUDED_DATA_FIELD));

    private final String stateMachineArn;

    private final String includedData;

    private DescribeStateMachineRequest(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.includedData = builder.includedData;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine for which you want the information.
     * </p>
     * <p>
     * If you specify a state machine version ARN, this API returns details about that version. The version ARN is a
     * combination of state machine ARN and the version number separated by a colon (:). For example,
     * <code>stateMachineARN:1</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the state machine for which you want the information.</p>
     *         <p>
     *         If you specify a state machine version ARN, this API returns details about that version. The version ARN
     *         is a combination of state machine ARN and the version number separated by a colon (:). For example,
     *         <code>stateMachineARN:1</code>.
     */
    public final String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * If your state machine definition is encrypted with a KMS key, callers must have <code>kms:Decrypt</code>
     * permission to decrypt the definition. Alternatively, you can call the API with
     * <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted definition.
     * </p>
     * <note>
     * <p>
     * When calling a labelled ARN for an encrypted state machine, the <code>includedData = METADATA_ONLY</code>
     * parameter will not apply because Step Functions needs to decrypt the entire state machine definition to get the
     * Distributed Map state’s definition. In this case, the API caller needs to have <code>kms:Decrypt</code>
     * permission.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #includedData} will
     * return {@link IncludedData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #includedDataAsString}.
     * </p>
     * 
     * @return If your state machine definition is encrypted with a KMS key, callers must have <code>kms:Decrypt</code>
     *         permission to decrypt the definition. Alternatively, you can call the API with
     *         <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted
     *         definition.</p> <note>
     *         <p>
     *         When calling a labelled ARN for an encrypted state machine, the <code>includedData = METADATA_ONLY</code>
     *         parameter will not apply because Step Functions needs to decrypt the entire state machine definition to
     *         get the Distributed Map state’s definition. In this case, the API caller needs to have
     *         <code>kms:Decrypt</code> permission.
     *         </p>
     * @see IncludedData
     */
    public final IncludedData includedData() {
        return IncludedData.fromValue(includedData);
    }

    /**
     * <p>
     * If your state machine definition is encrypted with a KMS key, callers must have <code>kms:Decrypt</code>
     * permission to decrypt the definition. Alternatively, you can call the API with
     * <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted definition.
     * </p>
     * <note>
     * <p>
     * When calling a labelled ARN for an encrypted state machine, the <code>includedData = METADATA_ONLY</code>
     * parameter will not apply because Step Functions needs to decrypt the entire state machine definition to get the
     * Distributed Map state’s definition. In this case, the API caller needs to have <code>kms:Decrypt</code>
     * permission.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #includedData} will
     * return {@link IncludedData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #includedDataAsString}.
     * </p>
     * 
     * @return If your state machine definition is encrypted with a KMS key, callers must have <code>kms:Decrypt</code>
     *         permission to decrypt the definition. Alternatively, you can call the API with
     *         <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted
     *         definition.</p> <note>
     *         <p>
     *         When calling a labelled ARN for an encrypted state machine, the <code>includedData = METADATA_ONLY</code>
     *         parameter will not apply because Step Functions needs to decrypt the entire state machine definition to
     *         get the Distributed Map state’s definition. In this case, the API caller needs to have
     *         <code>kms:Decrypt</code> permission.
     *         </p>
     * @see IncludedData
     */
    public final String includedDataAsString() {
        return includedData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(includedDataAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStateMachineRequest)) {
            return false;
        }
        DescribeStateMachineRequest other = (DescribeStateMachineRequest) obj;
        return Objects.equals(stateMachineArn(), other.stateMachineArn())
                && Objects.equals(includedDataAsString(), other.includedDataAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStateMachineRequest").add("StateMachineArn", stateMachineArn())
                .add("IncludedData", includedDataAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "includedData":
            return Optional.ofNullable(clazz.cast(includedDataAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStateMachineRequest, T> g) {
        return obj -> g.apply((DescribeStateMachineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStateMachineRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the state machine for which you want the information.
         * </p>
         * <p>
         * If you specify a state machine version ARN, this API returns details about that version. The version ARN is a
         * combination of state machine ARN and the version number separated by a colon (:). For example,
         * <code>stateMachineARN:1</code>.
         * </p>
         * 
         * @param stateMachineArn
         *        The Amazon Resource Name (ARN) of the state machine for which you want the information.</p>
         *        <p>
         *        If you specify a state machine version ARN, this API returns details about that version. The version
         *        ARN is a combination of state machine ARN and the version number separated by a colon (:). For
         *        example, <code>stateMachineARN:1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * If your state machine definition is encrypted with a KMS key, callers must have <code>kms:Decrypt</code>
         * permission to decrypt the definition. Alternatively, you can call the API with
         * <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted definition.
         * </p>
         * <note>
         * <p>
         * When calling a labelled ARN for an encrypted state machine, the <code>includedData = METADATA_ONLY</code>
         * parameter will not apply because Step Functions needs to decrypt the entire state machine definition to get
         * the Distributed Map state’s definition. In this case, the API caller needs to have <code>kms:Decrypt</code>
         * permission.
         * </p>
         * </note>
         * 
         * @param includedData
         *        If your state machine definition is encrypted with a KMS key, callers must have
         *        <code>kms:Decrypt</code> permission to decrypt the definition. Alternatively, you can call the API
         *        with <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted
         *        definition.</p> <note>
         *        <p>
         *        When calling a labelled ARN for an encrypted state machine, the
         *        <code>includedData = METADATA_ONLY</code> parameter will not apply because Step Functions needs to
         *        decrypt the entire state machine definition to get the Distributed Map state’s definition. In this
         *        case, the API caller needs to have <code>kms:Decrypt</code> permission.
         *        </p>
         * @see IncludedData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludedData
         */
        Builder includedData(String includedData);

        /**
         * <p>
         * If your state machine definition is encrypted with a KMS key, callers must have <code>kms:Decrypt</code>
         * permission to decrypt the definition. Alternatively, you can call the API with
         * <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted definition.
         * </p>
         * <note>
         * <p>
         * When calling a labelled ARN for an encrypted state machine, the <code>includedData = METADATA_ONLY</code>
         * parameter will not apply because Step Functions needs to decrypt the entire state machine definition to get
         * the Distributed Map state’s definition. In this case, the API caller needs to have <code>kms:Decrypt</code>
         * permission.
         * </p>
         * </note>
         * 
         * @param includedData
         *        If your state machine definition is encrypted with a KMS key, callers must have
         *        <code>kms:Decrypt</code> permission to decrypt the definition. Alternatively, you can call the API
         *        with <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted
         *        definition.</p> <note>
         *        <p>
         *        When calling a labelled ARN for an encrypted state machine, the
         *        <code>includedData = METADATA_ONLY</code> parameter will not apply because Step Functions needs to
         *        decrypt the entire state machine definition to get the Distributed Map state’s definition. In this
         *        case, the API caller needs to have <code>kms:Decrypt</code> permission.
         *        </p>
         * @see IncludedData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludedData
         */
        Builder includedData(IncludedData includedData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String stateMachineArn;

        private String includedData;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStateMachineRequest model) {
            super(model);
            stateMachineArn(model.stateMachineArn);
            includedData(model.includedData);
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getIncludedData() {
            return includedData;
        }

        public final void setIncludedData(String includedData) {
            this.includedData = includedData;
        }

        @Override
        public final Builder includedData(String includedData) {
            this.includedData = includedData;
            return this;
        }

        @Override
        public final Builder includedData(IncludedData includedData) {
            this.includedData(includedData == null ? null : includedData.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStateMachineRequest build() {
            return new DescribeStateMachineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
