/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateActivityResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, CreateActivityResponse> {
    private static final SdkField<String> ACTIVITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activityArn").getter(CreateActivityResponse.getter(CreateActivityResponse::activityArn)).setter(CreateActivityResponse.setter(Builder::activityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(CreateActivityResponse.getter(CreateActivityResponse::creationDate)).setter(CreateActivityResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_ARN_FIELD, CREATION_DATE_FIELD));
    private final String activityArn;
    private final Instant creationDate;

    private CreateActivityResponse(BuilderImpl builder) {
        super(builder);
        this.activityArn = builder.activityArn;
        this.creationDate = builder.creationDate;
    }

    public final String activityArn() {
        return this.activityArn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.activityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActivityResponse)) {
            return false;
        }
        CreateActivityResponse other = (CreateActivityResponse)((Object)obj);
        return Objects.equals(this.activityArn(), other.activityArn()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public final String toString() {
        return ToString.builder((String)"CreateActivityResponse").add("ActivityArn", (Object)this.activityArn()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activityArn": {
                return Optional.ofNullable(clazz.cast(this.activityArn()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateActivityResponse, T> g) {
        return obj -> g.apply((CreateActivityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String activityArn;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActivityResponse model) {
            super(model);
            this.activityArn(model.activityArn);
            this.creationDate(model.creationDate);
        }

        public final String getActivityArn() {
            return this.activityArn;
        }

        public final void setActivityArn(String activityArn) {
            this.activityArn = activityArn;
        }

        @Override
        public final Builder activityArn(String activityArn) {
            this.activityArn = activityArn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public CreateActivityResponse build() {
            return new CreateActivityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateActivityResponse> {
        public Builder activityArn(String var1);

        public Builder creationDate(Instant var1);
    }
}

