/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.RecommendationImpact;
import software.amazon.awssdk.services.sesv2.model.ReputationEntityType;
import software.amazon.awssdk.services.sesv2.model.SendingStatus;
import software.amazon.awssdk.services.sesv2.model.StatusRecord;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReputationEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReputationEntity> {
    private static final SdkField<String> REPUTATION_ENTITY_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReputationEntityReference").getter(ReputationEntity.getter(ReputationEntity::reputationEntityReference)).setter(ReputationEntity.setter(Builder::reputationEntityReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationEntityReference").build()}).build();
    private static final SdkField<String> REPUTATION_ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReputationEntityType").getter(ReputationEntity.getter(ReputationEntity::reputationEntityTypeAsString)).setter(ReputationEntity.setter(Builder::reputationEntityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationEntityType").build()}).build();
    private static final SdkField<String> REPUTATION_MANAGEMENT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReputationManagementPolicy").getter(ReputationEntity.getter(ReputationEntity::reputationManagementPolicy)).setter(ReputationEntity.setter(Builder::reputationManagementPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationManagementPolicy").build()}).build();
    private static final SdkField<StatusRecord> CUSTOMER_MANAGED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomerManagedStatus").getter(ReputationEntity.getter(ReputationEntity::customerManagedStatus)).setter(ReputationEntity.setter(Builder::customerManagedStatus)).constructor(StatusRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerManagedStatus").build()}).build();
    private static final SdkField<StatusRecord> AWS_SES_MANAGED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsSesManagedStatus").getter(ReputationEntity.getter(ReputationEntity::awsSesManagedStatus)).setter(ReputationEntity.setter(Builder::awsSesManagedStatus)).constructor(StatusRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSesManagedStatus").build()}).build();
    private static final SdkField<String> SENDING_STATUS_AGGREGATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SendingStatusAggregate").getter(ReputationEntity.getter(ReputationEntity::sendingStatusAggregateAsString)).setter(ReputationEntity.setter(Builder::sendingStatusAggregate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingStatusAggregate").build()}).build();
    private static final SdkField<String> REPUTATION_IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReputationImpact").getter(ReputationEntity.getter(ReputationEntity::reputationImpactAsString)).setter(ReputationEntity.setter(Builder::reputationImpact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationImpact").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPUTATION_ENTITY_REFERENCE_FIELD, REPUTATION_ENTITY_TYPE_FIELD, REPUTATION_MANAGEMENT_POLICY_FIELD, CUSTOMER_MANAGED_STATUS_FIELD, AWS_SES_MANAGED_STATUS_FIELD, SENDING_STATUS_AGGREGATE_FIELD, REPUTATION_IMPACT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReputationEntity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reputationEntityReference;
    private final String reputationEntityType;
    private final String reputationManagementPolicy;
    private final StatusRecord customerManagedStatus;
    private final StatusRecord awsSesManagedStatus;
    private final String sendingStatusAggregate;
    private final String reputationImpact;

    private ReputationEntity(BuilderImpl builder) {
        this.reputationEntityReference = builder.reputationEntityReference;
        this.reputationEntityType = builder.reputationEntityType;
        this.reputationManagementPolicy = builder.reputationManagementPolicy;
        this.customerManagedStatus = builder.customerManagedStatus;
        this.awsSesManagedStatus = builder.awsSesManagedStatus;
        this.sendingStatusAggregate = builder.sendingStatusAggregate;
        this.reputationImpact = builder.reputationImpact;
    }

    public final String reputationEntityReference() {
        return this.reputationEntityReference;
    }

    public final ReputationEntityType reputationEntityType() {
        return ReputationEntityType.fromValue(this.reputationEntityType);
    }

    public final String reputationEntityTypeAsString() {
        return this.reputationEntityType;
    }

    public final String reputationManagementPolicy() {
        return this.reputationManagementPolicy;
    }

    public final StatusRecord customerManagedStatus() {
        return this.customerManagedStatus;
    }

    public final StatusRecord awsSesManagedStatus() {
        return this.awsSesManagedStatus;
    }

    public final SendingStatus sendingStatusAggregate() {
        return SendingStatus.fromValue(this.sendingStatusAggregate);
    }

    public final String sendingStatusAggregateAsString() {
        return this.sendingStatusAggregate;
    }

    public final RecommendationImpact reputationImpact() {
        return RecommendationImpact.fromValue(this.reputationImpact);
    }

    public final String reputationImpactAsString() {
        return this.reputationImpact;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reputationEntityReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.reputationEntityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reputationManagementPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManagedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsSesManagedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendingStatusAggregateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reputationImpactAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReputationEntity)) {
            return false;
        }
        ReputationEntity other = (ReputationEntity)obj;
        return Objects.equals(this.reputationEntityReference(), other.reputationEntityReference()) && Objects.equals(this.reputationEntityTypeAsString(), other.reputationEntityTypeAsString()) && Objects.equals(this.reputationManagementPolicy(), other.reputationManagementPolicy()) && Objects.equals(this.customerManagedStatus(), other.customerManagedStatus()) && Objects.equals(this.awsSesManagedStatus(), other.awsSesManagedStatus()) && Objects.equals(this.sendingStatusAggregateAsString(), other.sendingStatusAggregateAsString()) && Objects.equals(this.reputationImpactAsString(), other.reputationImpactAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReputationEntity").add("ReputationEntityReference", (Object)this.reputationEntityReference()).add("ReputationEntityType", (Object)this.reputationEntityTypeAsString()).add("ReputationManagementPolicy", (Object)this.reputationManagementPolicy()).add("CustomerManagedStatus", (Object)this.customerManagedStatus()).add("AwsSesManagedStatus", (Object)this.awsSesManagedStatus()).add("SendingStatusAggregate", (Object)this.sendingStatusAggregateAsString()).add("ReputationImpact", (Object)this.reputationImpactAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReputationEntityReference": {
                return Optional.ofNullable(clazz.cast(this.reputationEntityReference()));
            }
            case "ReputationEntityType": {
                return Optional.ofNullable(clazz.cast(this.reputationEntityTypeAsString()));
            }
            case "ReputationManagementPolicy": {
                return Optional.ofNullable(clazz.cast(this.reputationManagementPolicy()));
            }
            case "CustomerManagedStatus": {
                return Optional.ofNullable(clazz.cast(this.customerManagedStatus()));
            }
            case "AwsSesManagedStatus": {
                return Optional.ofNullable(clazz.cast(this.awsSesManagedStatus()));
            }
            case "SendingStatusAggregate": {
                return Optional.ofNullable(clazz.cast(this.sendingStatusAggregateAsString()));
            }
            case "ReputationImpact": {
                return Optional.ofNullable(clazz.cast(this.reputationImpactAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReputationEntityReference", REPUTATION_ENTITY_REFERENCE_FIELD);
        map.put("ReputationEntityType", REPUTATION_ENTITY_TYPE_FIELD);
        map.put("ReputationManagementPolicy", REPUTATION_MANAGEMENT_POLICY_FIELD);
        map.put("CustomerManagedStatus", CUSTOMER_MANAGED_STATUS_FIELD);
        map.put("AwsSesManagedStatus", AWS_SES_MANAGED_STATUS_FIELD);
        map.put("SendingStatusAggregate", SENDING_STATUS_AGGREGATE_FIELD);
        map.put("ReputationImpact", REPUTATION_IMPACT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReputationEntity, T> g) {
        return obj -> g.apply((ReputationEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reputationEntityReference;
        private String reputationEntityType;
        private String reputationManagementPolicy;
        private StatusRecord customerManagedStatus;
        private StatusRecord awsSesManagedStatus;
        private String sendingStatusAggregate;
        private String reputationImpact;

        private BuilderImpl() {
        }

        private BuilderImpl(ReputationEntity model) {
            this.reputationEntityReference(model.reputationEntityReference);
            this.reputationEntityType(model.reputationEntityType);
            this.reputationManagementPolicy(model.reputationManagementPolicy);
            this.customerManagedStatus(model.customerManagedStatus);
            this.awsSesManagedStatus(model.awsSesManagedStatus);
            this.sendingStatusAggregate(model.sendingStatusAggregate);
            this.reputationImpact(model.reputationImpact);
        }

        public final String getReputationEntityReference() {
            return this.reputationEntityReference;
        }

        public final void setReputationEntityReference(String reputationEntityReference) {
            this.reputationEntityReference = reputationEntityReference;
        }

        @Override
        public final Builder reputationEntityReference(String reputationEntityReference) {
            this.reputationEntityReference = reputationEntityReference;
            return this;
        }

        public final String getReputationEntityType() {
            return this.reputationEntityType;
        }

        public final void setReputationEntityType(String reputationEntityType) {
            this.reputationEntityType = reputationEntityType;
        }

        @Override
        public final Builder reputationEntityType(String reputationEntityType) {
            this.reputationEntityType = reputationEntityType;
            return this;
        }

        @Override
        public final Builder reputationEntityType(ReputationEntityType reputationEntityType) {
            this.reputationEntityType(reputationEntityType == null ? null : reputationEntityType.toString());
            return this;
        }

        public final String getReputationManagementPolicy() {
            return this.reputationManagementPolicy;
        }

        public final void setReputationManagementPolicy(String reputationManagementPolicy) {
            this.reputationManagementPolicy = reputationManagementPolicy;
        }

        @Override
        public final Builder reputationManagementPolicy(String reputationManagementPolicy) {
            this.reputationManagementPolicy = reputationManagementPolicy;
            return this;
        }

        public final StatusRecord.Builder getCustomerManagedStatus() {
            return this.customerManagedStatus != null ? this.customerManagedStatus.toBuilder() : null;
        }

        public final void setCustomerManagedStatus(StatusRecord.BuilderImpl customerManagedStatus) {
            this.customerManagedStatus = customerManagedStatus != null ? customerManagedStatus.build() : null;
        }

        @Override
        public final Builder customerManagedStatus(StatusRecord customerManagedStatus) {
            this.customerManagedStatus = customerManagedStatus;
            return this;
        }

        public final StatusRecord.Builder getAwsSesManagedStatus() {
            return this.awsSesManagedStatus != null ? this.awsSesManagedStatus.toBuilder() : null;
        }

        public final void setAwsSesManagedStatus(StatusRecord.BuilderImpl awsSesManagedStatus) {
            this.awsSesManagedStatus = awsSesManagedStatus != null ? awsSesManagedStatus.build() : null;
        }

        @Override
        public final Builder awsSesManagedStatus(StatusRecord awsSesManagedStatus) {
            this.awsSesManagedStatus = awsSesManagedStatus;
            return this;
        }

        public final String getSendingStatusAggregate() {
            return this.sendingStatusAggregate;
        }

        public final void setSendingStatusAggregate(String sendingStatusAggregate) {
            this.sendingStatusAggregate = sendingStatusAggregate;
        }

        @Override
        public final Builder sendingStatusAggregate(String sendingStatusAggregate) {
            this.sendingStatusAggregate = sendingStatusAggregate;
            return this;
        }

        @Override
        public final Builder sendingStatusAggregate(SendingStatus sendingStatusAggregate) {
            this.sendingStatusAggregate(sendingStatusAggregate == null ? null : sendingStatusAggregate.toString());
            return this;
        }

        public final String getReputationImpact() {
            return this.reputationImpact;
        }

        public final void setReputationImpact(String reputationImpact) {
            this.reputationImpact = reputationImpact;
        }

        @Override
        public final Builder reputationImpact(String reputationImpact) {
            this.reputationImpact = reputationImpact;
            return this;
        }

        @Override
        public final Builder reputationImpact(RecommendationImpact reputationImpact) {
            this.reputationImpact(reputationImpact == null ? null : reputationImpact.toString());
            return this;
        }

        public ReputationEntity build() {
            return new ReputationEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReputationEntity> {
        public Builder reputationEntityReference(String var1);

        public Builder reputationEntityType(String var1);

        public Builder reputationEntityType(ReputationEntityType var1);

        public Builder reputationManagementPolicy(String var1);

        public Builder customerManagedStatus(StatusRecord var1);

        default public Builder customerManagedStatus(Consumer<StatusRecord.Builder> customerManagedStatus) {
            return this.customerManagedStatus((StatusRecord)((StatusRecord.Builder)StatusRecord.builder().applyMutation(customerManagedStatus)).build());
        }

        public Builder awsSesManagedStatus(StatusRecord var1);

        default public Builder awsSesManagedStatus(Consumer<StatusRecord.Builder> awsSesManagedStatus) {
            return this.awsSesManagedStatus((StatusRecord)((StatusRecord.Builder)StatusRecord.builder().applyMutation(awsSesManagedStatus)).build());
        }

        public Builder sendingStatusAggregate(String var1);

        public Builder sendingStatusAggregate(SendingStatus var1);

        public Builder reputationImpact(String var1);

        public Builder reputationImpact(RecommendationImpact var1);
    }
}

