/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.SuppressionListReason;
import software.amazon.awssdk.services.sesv2.model.SuppressionListReasonsCopier;
import software.amazon.awssdk.services.sesv2.model.SuppressionValidationAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuppressionAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuppressionAttributes> {
    private static final SdkField<List<String>> SUPPRESSED_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuppressedReasons").getter(SuppressionAttributes.getter(SuppressionAttributes::suppressedReasonsAsStrings)).setter(SuppressionAttributes.setter(Builder::suppressedReasonsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressedReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SuppressionValidationAttributes> VALIDATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidationAttributes").getter(SuppressionAttributes.getter(SuppressionAttributes::validationAttributes)).setter(SuppressionAttributes.setter(Builder::validationAttributes)).constructor(SuppressionValidationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPRESSED_REASONS_FIELD, VALIDATION_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SuppressionAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> suppressedReasons;
    private final SuppressionValidationAttributes validationAttributes;

    private SuppressionAttributes(BuilderImpl builder) {
        this.suppressedReasons = builder.suppressedReasons;
        this.validationAttributes = builder.validationAttributes;
    }

    public final List<SuppressionListReason> suppressedReasons() {
        return SuppressionListReasonsCopier.copyStringToEnum(this.suppressedReasons);
    }

    public final boolean hasSuppressedReasons() {
        return this.suppressedReasons != null && !(this.suppressedReasons instanceof SdkAutoConstructList);
    }

    public final List<String> suppressedReasonsAsStrings() {
        return this.suppressedReasons;
    }

    public final SuppressionValidationAttributes validationAttributes() {
        return this.validationAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuppressedReasons() ? this.suppressedReasonsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.validationAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuppressionAttributes)) {
            return false;
        }
        SuppressionAttributes other = (SuppressionAttributes)obj;
        return this.hasSuppressedReasons() == other.hasSuppressedReasons() && Objects.equals(this.suppressedReasonsAsStrings(), other.suppressedReasonsAsStrings()) && Objects.equals(this.validationAttributes(), other.validationAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"SuppressionAttributes").add("SuppressedReasons", this.hasSuppressedReasons() ? this.suppressedReasonsAsStrings() : null).add("ValidationAttributes", (Object)this.validationAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuppressedReasons": {
                return Optional.ofNullable(clazz.cast(this.suppressedReasonsAsStrings()));
            }
            case "ValidationAttributes": {
                return Optional.ofNullable(clazz.cast(this.validationAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SuppressedReasons", SUPPRESSED_REASONS_FIELD);
        map.put("ValidationAttributes", VALIDATION_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuppressionAttributes, T> g) {
        return obj -> g.apply((SuppressionAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> suppressedReasons = DefaultSdkAutoConstructList.getInstance();
        private SuppressionValidationAttributes validationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(SuppressionAttributes model) {
            this.suppressedReasonsWithStrings(model.suppressedReasons);
            this.validationAttributes(model.validationAttributes);
        }

        public final Collection<String> getSuppressedReasons() {
            if (this.suppressedReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.suppressedReasons;
        }

        public final void setSuppressedReasons(Collection<String> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copy(suppressedReasons);
        }

        @Override
        public final Builder suppressedReasonsWithStrings(Collection<String> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copy(suppressedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedReasonsWithStrings(String ... suppressedReasons) {
            this.suppressedReasonsWithStrings(Arrays.asList(suppressedReasons));
            return this;
        }

        @Override
        public final Builder suppressedReasons(Collection<SuppressionListReason> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copyEnumToString(suppressedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedReasons(SuppressionListReason ... suppressedReasons) {
            this.suppressedReasons(Arrays.asList(suppressedReasons));
            return this;
        }

        public final SuppressionValidationAttributes.Builder getValidationAttributes() {
            return this.validationAttributes != null ? this.validationAttributes.toBuilder() : null;
        }

        public final void setValidationAttributes(SuppressionValidationAttributes.BuilderImpl validationAttributes) {
            this.validationAttributes = validationAttributes != null ? validationAttributes.build() : null;
        }

        @Override
        public final Builder validationAttributes(SuppressionValidationAttributes validationAttributes) {
            this.validationAttributes = validationAttributes;
            return this;
        }

        public SuppressionAttributes build() {
            return new SuppressionAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuppressionAttributes> {
        public Builder suppressedReasonsWithStrings(Collection<String> var1);

        public Builder suppressedReasonsWithStrings(String ... var1);

        public Builder suppressedReasons(Collection<SuppressionListReason> var1);

        public Builder suppressedReasons(SuppressionListReason ... var1);

        public Builder validationAttributes(SuppressionValidationAttributes var1);

        default public Builder validationAttributes(Consumer<SuppressionValidationAttributes.Builder> validationAttributes) {
            return this.validationAttributes((SuppressionValidationAttributes)((SuppressionValidationAttributes.Builder)SuppressionValidationAttributes.builder().applyMutation(validationAttributes)).build());
        }
    }
}

