/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.Attachment;
import software.amazon.awssdk.services.sesv2.model.AttachmentListCopier;
import software.amazon.awssdk.services.sesv2.model.Body;
import software.amazon.awssdk.services.sesv2.model.Content;
import software.amazon.awssdk.services.sesv2.model.MessageHeader;
import software.amazon.awssdk.services.sesv2.model.MessageHeaderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Message
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Message> {
    private static final SdkField<Content> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subject").getter(Message.getter(Message::subject)).setter(Message.setter(Builder::subject)).constructor(Content::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<Body> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Body").getter(Message.getter(Message::body)).setter(Message.setter(Builder::body)).constructor(Body::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<List<MessageHeader>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Headers").getter(Message.getter(Message::headers)).setter(Message.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attachments").getter(Message.getter(Message::attachments)).setter(Message.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, BODY_FIELD, HEADERS_FIELD, ATTACHMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Message.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Content subject;
    private final Body body;
    private final List<MessageHeader> headers;
    private final List<Attachment> attachments;

    private Message(BuilderImpl builder) {
        this.subject = builder.subject;
        this.body = builder.body;
        this.headers = builder.headers;
        this.attachments = builder.attachments;
    }

    public final Content subject() {
        return this.subject;
    }

    public final Body body() {
        return this.body;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructList);
    }

    public final List<MessageHeader> headers() {
        return this.headers;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<Attachment> attachments() {
        return this.attachments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.subject(), other.subject()) && Objects.equals(this.body(), other.body()) && this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers()) && this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments());
    }

    public final String toString() {
        return ToString.builder((String)"Message").add("Subject", (Object)this.subject()).add("Body", (Object)this.body()).add("Headers", this.hasHeaders() ? this.headers() : null).add("Attachments", this.hasAttachments() ? this.attachments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "Headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "Attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Subject", SUBJECT_FIELD);
        map.put("Body", BODY_FIELD);
        map.put("Headers", HEADERS_FIELD);
        map.put("Attachments", ATTACHMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Content subject;
        private Body body;
        private List<MessageHeader> headers = DefaultSdkAutoConstructList.getInstance();
        private List<Attachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.subject(model.subject);
            this.body(model.body);
            this.headers(model.headers);
            this.attachments(model.attachments);
        }

        public final Content.Builder getSubject() {
            return this.subject != null ? this.subject.toBuilder() : null;
        }

        public final void setSubject(Content.BuilderImpl subject) {
            this.subject = subject != null ? subject.build() : null;
        }

        @Override
        public final Builder subject(Content subject) {
            this.subject = subject;
            return this;
        }

        public final Body.Builder getBody() {
            return this.body != null ? this.body.toBuilder() : null;
        }

        public final void setBody(Body.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(Body body) {
            this.body = body;
            return this;
        }

        public final List<MessageHeader.Builder> getHeaders() {
            List<MessageHeader.Builder> result = MessageHeaderListCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<MessageHeader.BuilderImpl> headers) {
            this.headers = MessageHeaderListCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<MessageHeader> headers) {
            this.headers = MessageHeaderListCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(MessageHeader ... headers) {
            this.headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<MessageHeader.Builder> ... headers) {
            this.headers(Stream.of(headers).map(c -> (MessageHeader)((MessageHeader.Builder)MessageHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Attachment.Builder> getAttachments() {
            List<Attachment.Builder> result = AttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<Attachment.BuilderImpl> attachments) {
            this.attachments = AttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<Attachment> attachments) {
            this.attachments = AttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Attachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<Attachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (Attachment)((Attachment.Builder)Attachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Message build() {
            return new Message(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Message> {
        public Builder subject(Content var1);

        default public Builder subject(Consumer<Content.Builder> subject) {
            return this.subject((Content)((Content.Builder)Content.builder().applyMutation(subject)).build());
        }

        public Builder body(Body var1);

        default public Builder body(Consumer<Body.Builder> body) {
            return this.body((Body)((Body.Builder)Body.builder().applyMutation(body)).build());
        }

        public Builder headers(Collection<MessageHeader> var1);

        public Builder headers(MessageHeader ... var1);

        public Builder headers(Consumer<MessageHeader.Builder> ... var1);

        public Builder attachments(Collection<Attachment> var1);

        public Builder attachments(Attachment ... var1);

        public Builder attachments(Consumer<Attachment.Builder> ... var1);
    }
}

