/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sesv2.model.ListTenantResourcesFilterCopier;
import software.amazon.awssdk.services.sesv2.model.ListTenantResourcesFilterKey;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTenantResourcesRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, ListTenantResourcesRequest> {
    private static final SdkField<String> TENANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantName").getter(ListTenantResourcesRequest.getter(ListTenantResourcesRequest::tenantName)).setter(ListTenantResourcesRequest.setter(Builder::tenantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantName").build()}).build();
    private static final SdkField<Map<String, String>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Filter").getter(ListTenantResourcesRequest.getter(ListTenantResourcesRequest::filterAsStrings)).setter(ListTenantResourcesRequest.setter(Builder::filterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(ListTenantResourcesRequest.getter(ListTenantResourcesRequest::pageSize)).setter(ListTenantResourcesRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTenantResourcesRequest.getter(ListTenantResourcesRequest::nextToken)).setter(ListTenantResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_NAME_FIELD, FILTER_FIELD, PAGE_SIZE_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTenantResourcesRequest.memberNameToFieldInitializer();
    private final String tenantName;
    private final Map<String, String> filter;
    private final Integer pageSize;
    private final String nextToken;

    private ListTenantResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.tenantName = builder.tenantName;
        this.filter = builder.filter;
        this.pageSize = builder.pageSize;
        this.nextToken = builder.nextToken;
    }

    public final String tenantName() {
        return this.tenantName;
    }

    public final Map<ListTenantResourcesFilterKey, String> filter() {
        return ListTenantResourcesFilterCopier.copyStringToEnum(this.filter);
    }

    public final boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> filterAsStrings() {
        return this.filter;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilter() ? this.filterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTenantResourcesRequest)) {
            return false;
        }
        ListTenantResourcesRequest other = (ListTenantResourcesRequest)((Object)obj);
        return Objects.equals(this.tenantName(), other.tenantName()) && this.hasFilter() == other.hasFilter() && Objects.equals(this.filterAsStrings(), other.filterAsStrings()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTenantResourcesRequest").add("TenantName", (Object)this.tenantName()).add("Filter", this.hasFilter() ? this.filterAsStrings() : null).add("PageSize", (Object)this.pageSize()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TenantName": {
                return Optional.ofNullable(clazz.cast(this.tenantName()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filterAsStrings()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TenantName", TENANT_NAME_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTenantResourcesRequest, T> g) {
        return obj -> g.apply((ListTenantResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String tenantName;
        private Map<String, String> filter = DefaultSdkAutoConstructMap.getInstance();
        private Integer pageSize;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTenantResourcesRequest model) {
            super(model);
            this.tenantName(model.tenantName);
            this.filterWithStrings(model.filter);
            this.pageSize(model.pageSize);
            this.nextToken(model.nextToken);
        }

        public final String getTenantName() {
            return this.tenantName;
        }

        public final void setTenantName(String tenantName) {
            this.tenantName = tenantName;
        }

        @Override
        public final Builder tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public final Map<String, String> getFilter() {
            if (this.filter instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filter;
        }

        public final void setFilter(Map<String, String> filter) {
            this.filter = ListTenantResourcesFilterCopier.copy(filter);
        }

        @Override
        public final Builder filterWithStrings(Map<String, String> filter) {
            this.filter = ListTenantResourcesFilterCopier.copy(filter);
            return this;
        }

        @Override
        public final Builder filter(Map<ListTenantResourcesFilterKey, String> filter) {
            this.filter = ListTenantResourcesFilterCopier.copyEnumToString(filter);
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTenantResourcesRequest build() {
            return new ListTenantResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTenantResourcesRequest> {
        public Builder tenantName(String var1);

        public Builder filterWithStrings(Map<String, String> var1);

        public Builder filter(Map<ListTenantResourcesFilterKey, String> var1);

        public Builder pageSize(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

