/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.EmailTemplateContent;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.services.sesv2.model.Tag;
import software.amazon.awssdk.services.sesv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEmailTemplateResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, GetEmailTemplateResponse> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(GetEmailTemplateResponse.getter(GetEmailTemplateResponse::templateName)).setter(GetEmailTemplateResponse.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<EmailTemplateContent> TEMPLATE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateContent").getter(GetEmailTemplateResponse.getter(GetEmailTemplateResponse::templateContent)).setter(GetEmailTemplateResponse.setter(Builder::templateContent)).constructor(EmailTemplateContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateContent").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(GetEmailTemplateResponse.getter(GetEmailTemplateResponse::tags)).setter(GetEmailTemplateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, TEMPLATE_CONTENT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEmailTemplateResponse.memberNameToFieldInitializer();
    private final String templateName;
    private final EmailTemplateContent templateContent;
    private final List<Tag> tags;

    private GetEmailTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.templateContent = builder.templateContent;
        this.tags = builder.tags;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final EmailTemplateContent templateContent() {
        return this.templateContent;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEmailTemplateResponse)) {
            return false;
        }
        GetEmailTemplateResponse other = (GetEmailTemplateResponse)((Object)obj);
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateContent(), other.templateContent()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetEmailTemplateResponse").add("TemplateName", (Object)this.templateName()).add("TemplateContent", (Object)this.templateContent()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "TemplateContent": {
                return Optional.ofNullable(clazz.cast(this.templateContent()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("TemplateContent", TEMPLATE_CONTENT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEmailTemplateResponse, T> g) {
        return obj -> g.apply((GetEmailTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private String templateName;
        private EmailTemplateContent templateContent;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEmailTemplateResponse model) {
            super(model);
            this.templateName(model.templateName);
            this.templateContent(model.templateContent);
            this.tags(model.tags);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final EmailTemplateContent.Builder getTemplateContent() {
            return this.templateContent != null ? this.templateContent.toBuilder() : null;
        }

        public final void setTemplateContent(EmailTemplateContent.BuilderImpl templateContent) {
            this.templateContent = templateContent != null ? templateContent.build() : null;
        }

        @Override
        public final Builder templateContent(EmailTemplateContent templateContent) {
            this.templateContent = templateContent;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEmailTemplateResponse build() {
            return new GetEmailTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEmailTemplateResponse> {
        public Builder templateName(String var1);

        public Builder templateContent(EmailTemplateContent var1);

        default public Builder templateContent(Consumer<EmailTemplateContent.Builder> templateContent) {
            return this.templateContent((EmailTemplateContent)((EmailTemplateContent.Builder)EmailTemplateContent.builder().applyMutation(templateContent)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

