/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesRequest;
import software.amazon.awssdk.services.sesv2.model.ListReputationEntitiesResponse;
import software.amazon.awssdk.services.sesv2.model.ReputationEntity;

public class ListReputationEntitiesIterable
implements SdkIterable<ListReputationEntitiesResponse> {
    private final SesV2Client client;
    private final ListReputationEntitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReputationEntitiesIterable(SesV2Client client, ListReputationEntitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReputationEntitiesResponseFetcher();
    }

    public Iterator<ListReputationEntitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReputationEntity> reputationEntities() {
        Function<ListReputationEntitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reputationEntities() != null) {
                return response.reputationEntities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReputationEntitiesResponseFetcher
    implements SyncPageFetcher<ListReputationEntitiesResponse> {
        private ListReputationEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListReputationEntitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReputationEntitiesResponse nextPage(ListReputationEntitiesResponse previousPage) {
            if (previousPage == null) {
                return ListReputationEntitiesIterable.this.client.listReputationEntities(ListReputationEntitiesIterable.this.firstRequest);
            }
            return ListReputationEntitiesIterable.this.client.listReputationEntities((ListReputationEntitiesRequest)((Object)ListReputationEntitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

