/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sesv2.endpoints.SesV2EndpointParams;
import software.amazon.awssdk.services.sesv2.endpoints.SesV2EndpointProvider;
import software.amazon.awssdk.services.sesv2.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.sesv2.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.sesv2.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultSesV2EndpointProvider
implements SesV2EndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(SesV2EndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(SesV2EndpointParams params, String region) {
        RuleResult result = DefaultSesV2EndpointProvider.endpointRule1(params, region);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultSesV2EndpointProvider.endpointRule12(params);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultSesV2EndpointProvider.endpointRule16(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule1(SesV2EndpointParams params, String region) {
        RulePartition partitionResult;
        if (params.endpointId() != null && region != null && (partitionResult = RulesFunctions.awsPartition(region)) != null) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule2(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("EndpointId must be a valid host label");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(SesV2EndpointParams params, RulePartition partitionResult) {
        if (RulesFunctions.isValidHostLabel(params.endpointId(), true)) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule3(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid Configuration: FIPS is not supported with multi-region endpoints");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(SesV2EndpointParams params, RulePartition partitionResult) {
        if (!params.useFips().booleanValue()) {
            if (params.endpoint() != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("ses").signingRegionSet(Arrays.asList("*")).build())).build());
            }
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule5(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.endpointId() + ".endpoints.email." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("ses").signingRegionSet(Arrays.asList("*")).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(SesV2EndpointParams params, RulePartition partitionResult) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule6(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(SesV2EndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.endpointId() + ".endpoints.email.global." + partitionResult.dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("ses").signingRegionSet(Arrays.asList("*")).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(SesV2EndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(SesV2EndpointParams params, String region) {
        if (region != null) {
            return DefaultSesV2EndpointProvider.endpointRule17(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(SesV2EndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule18(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultSesV2EndpointProvider.endpointRule22(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultSesV2EndpointProvider.endpointRule26(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://email." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(SesV2EndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule19(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(SesV2EndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://email-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(SesV2EndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule23(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(SesV2EndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://email-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule26(SesV2EndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultSesV2EndpointProvider.endpointRule27(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule27(SesV2EndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://email." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

