/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse;

public class GetDedicatedIpsIterable
implements SdkIterable<GetDedicatedIpsResponse> {
    private final SesV2Client client;
    private final GetDedicatedIpsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDedicatedIpsIterable(SesV2Client client, GetDedicatedIpsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetDedicatedIpsResponseFetcher();
    }

    public Iterator<GetDedicatedIpsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetDedicatedIpsResponseFetcher
    implements SyncPageFetcher<GetDedicatedIpsResponse> {
        private GetDedicatedIpsResponseFetcher() {
        }

        public boolean hasNextPage(GetDedicatedIpsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetDedicatedIpsResponse nextPage(GetDedicatedIpsResponse previousPage) {
            if (previousPage == null) {
                return GetDedicatedIpsIterable.this.client.getDedicatedIps(GetDedicatedIpsIterable.this.firstRequest);
            }
            return GetDedicatedIpsIterable.this.client.getDedicatedIps((GetDedicatedIpsRequest)((Object)GetDedicatedIpsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

