/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse;

public class ListSuppressedDestinationsIterable
implements SdkIterable<ListSuppressedDestinationsResponse> {
    private final SesV2Client client;
    private final ListSuppressedDestinationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSuppressedDestinationsIterable(SesV2Client client, ListSuppressedDestinationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSuppressedDestinationsResponseFetcher();
    }

    public Iterator<ListSuppressedDestinationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSuppressedDestinationsResponseFetcher
    implements SyncPageFetcher<ListSuppressedDestinationsResponse> {
        private ListSuppressedDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSuppressedDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSuppressedDestinationsResponse nextPage(ListSuppressedDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListSuppressedDestinationsIterable.this.client.listSuppressedDestinations(ListSuppressedDestinationsIterable.this.firstRequest);
            }
            return ListSuppressedDestinationsIterable.this.client.listSuppressedDestinations((ListSuppressedDestinationsRequest)((Object)ListSuppressedDestinationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

