/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An interest group, theme, or label within a list. Lists can have multiple topics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Topic implements SdkPojo, Serializable, ToCopyableBuilder<Topic.Builder, Topic> {
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicName").getter(getter(Topic::topicName)).setter(setter(Builder::topicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(Topic::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Topic::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEFAULT_SUBSCRIPTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultSubscriptionStatus").getter(getter(Topic::defaultSubscriptionStatusAsString))
            .setter(setter(Builder::defaultSubscriptionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubscriptionStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_NAME_FIELD,
            DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, DEFAULT_SUBSCRIPTION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String topicName;

    private final String displayName;

    private final String description;

    private final String defaultSubscriptionStatus;

    private Topic(BuilderImpl builder) {
        this.topicName = builder.topicName;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.defaultSubscriptionStatus = builder.defaultSubscriptionStatus;
    }

    /**
     * <p>
     * The name of the topic.
     * </p>
     * 
     * @return The name of the topic.
     */
    public final String topicName() {
        return topicName;
    }

    /**
     * <p>
     * The name of the topic the contact will see.
     * </p>
     * 
     * @return The name of the topic the contact will see.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A description of what the topic is about, which the contact will see.
     * </p>
     * 
     * @return A description of what the topic is about, which the contact will see.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The default subscription status to be applied to a contact if the contact has not noted their preference for
     * subscribing to a topic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultSubscriptionStatus} will return {@link SubscriptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultSubscriptionStatusAsString}.
     * </p>
     * 
     * @return The default subscription status to be applied to a contact if the contact has not noted their preference
     *         for subscribing to a topic.
     * @see SubscriptionStatus
     */
    public final SubscriptionStatus defaultSubscriptionStatus() {
        return SubscriptionStatus.fromValue(defaultSubscriptionStatus);
    }

    /**
     * <p>
     * The default subscription status to be applied to a contact if the contact has not noted their preference for
     * subscribing to a topic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultSubscriptionStatus} will return {@link SubscriptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultSubscriptionStatusAsString}.
     * </p>
     * 
     * @return The default subscription status to be applied to a contact if the contact has not noted their preference
     *         for subscribing to a topic.
     * @see SubscriptionStatus
     */
    public final String defaultSubscriptionStatusAsString() {
        return defaultSubscriptionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSubscriptionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Topic)) {
            return false;
        }
        Topic other = (Topic) obj;
        return Objects.equals(topicName(), other.topicName()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(description(), other.description())
                && Objects.equals(defaultSubscriptionStatusAsString(), other.defaultSubscriptionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Topic").add("TopicName", topicName()).add("DisplayName", displayName())
                .add("Description", description()).add("DefaultSubscriptionStatus", defaultSubscriptionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicName":
            return Optional.ofNullable(clazz.cast(topicName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultSubscriptionStatus":
            return Optional.ofNullable(clazz.cast(defaultSubscriptionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Topic, T> g) {
        return obj -> g.apply((Topic) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Topic> {
        /**
         * <p>
         * The name of the topic.
         * </p>
         * 
         * @param topicName
         *        The name of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicName(String topicName);

        /**
         * <p>
         * The name of the topic the contact will see.
         * </p>
         * 
         * @param displayName
         *        The name of the topic the contact will see.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A description of what the topic is about, which the contact will see.
         * </p>
         * 
         * @param description
         *        A description of what the topic is about, which the contact will see.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The default subscription status to be applied to a contact if the contact has not noted their preference for
         * subscribing to a topic.
         * </p>
         * 
         * @param defaultSubscriptionStatus
         *        The default subscription status to be applied to a contact if the contact has not noted their
         *        preference for subscribing to a topic.
         * @see SubscriptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionStatus
         */
        Builder defaultSubscriptionStatus(String defaultSubscriptionStatus);

        /**
         * <p>
         * The default subscription status to be applied to a contact if the contact has not noted their preference for
         * subscribing to a topic.
         * </p>
         * 
         * @param defaultSubscriptionStatus
         *        The default subscription status to be applied to a contact if the contact has not noted their
         *        preference for subscribing to a topic.
         * @see SubscriptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionStatus
         */
        Builder defaultSubscriptionStatus(SubscriptionStatus defaultSubscriptionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String topicName;

        private String displayName;

        private String description;

        private String defaultSubscriptionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Topic model) {
            topicName(model.topicName);
            displayName(model.displayName);
            description(model.description);
            defaultSubscriptionStatus(model.defaultSubscriptionStatus);
        }

        public final String getTopicName() {
            return topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        @Transient
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultSubscriptionStatus() {
            return defaultSubscriptionStatus;
        }

        public final void setDefaultSubscriptionStatus(String defaultSubscriptionStatus) {
            this.defaultSubscriptionStatus = defaultSubscriptionStatus;
        }

        @Override
        @Transient
        public final Builder defaultSubscriptionStatus(String defaultSubscriptionStatus) {
            this.defaultSubscriptionStatus = defaultSubscriptionStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder defaultSubscriptionStatus(SubscriptionStatus defaultSubscriptionStatus) {
            this.defaultSubscriptionStatus(defaultSubscriptionStatus == null ? null : defaultSubscriptionStatus.toString());
            return this;
        }

        @Override
        public Topic build() {
            return new Topic(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
