/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ReplaceEmailContent</code> object to be used for a specific <code>BulkEmailEntry</code>. The
 * <code>ReplacementTemplate</code> can be specified within this object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplacementEmailContent implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplacementEmailContent.Builder, ReplacementEmailContent> {
    private static final SdkField<ReplacementTemplate> REPLACEMENT_TEMPLATE_FIELD = SdkField
            .<ReplacementTemplate> builder(MarshallingType.SDK_POJO).memberName("ReplacementTemplate")
            .getter(getter(ReplacementEmailContent::replacementTemplate)).setter(setter(Builder::replacementTemplate))
            .constructor(ReplacementTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementTemplate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLACEMENT_TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ReplacementTemplate replacementTemplate;

    private ReplacementEmailContent(BuilderImpl builder) {
        this.replacementTemplate = builder.replacementTemplate;
    }

    /**
     * <p>
     * The <code>ReplacementTemplate</code> associated with <code>ReplacementEmailContent</code>.
     * </p>
     * 
     * @return The <code>ReplacementTemplate</code> associated with <code>ReplacementEmailContent</code>.
     */
    public final ReplacementTemplate replacementTemplate() {
        return replacementTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replacementTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplacementEmailContent)) {
            return false;
        }
        ReplacementEmailContent other = (ReplacementEmailContent) obj;
        return Objects.equals(replacementTemplate(), other.replacementTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplacementEmailContent").add("ReplacementTemplate", replacementTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplacementTemplate":
            return Optional.ofNullable(clazz.cast(replacementTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplacementEmailContent, T> g) {
        return obj -> g.apply((ReplacementEmailContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplacementEmailContent> {
        /**
         * <p>
         * The <code>ReplacementTemplate</code> associated with <code>ReplacementEmailContent</code>.
         * </p>
         * 
         * @param replacementTemplate
         *        The <code>ReplacementTemplate</code> associated with <code>ReplacementEmailContent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementTemplate(ReplacementTemplate replacementTemplate);

        /**
         * <p>
         * The <code>ReplacementTemplate</code> associated with <code>ReplacementEmailContent</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link ReplacementTemplate.Builder} avoiding the need
         * to create one manually via {@link ReplacementTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplacementTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #replacementTemplate(ReplacementTemplate)}.
         * 
         * @param replacementTemplate
         *        a consumer that will call methods on {@link ReplacementTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replacementTemplate(ReplacementTemplate)
         */
        default Builder replacementTemplate(Consumer<ReplacementTemplate.Builder> replacementTemplate) {
            return replacementTemplate(ReplacementTemplate.builder().applyMutation(replacementTemplate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReplacementTemplate replacementTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplacementEmailContent model) {
            replacementTemplate(model.replacementTemplate);
        }

        public final ReplacementTemplate.Builder getReplacementTemplate() {
            return replacementTemplate != null ? replacementTemplate.toBuilder() : null;
        }

        public final void setReplacementTemplate(ReplacementTemplate.BuilderImpl replacementTemplate) {
            this.replacementTemplate = replacementTemplate != null ? replacementTemplate.build() : null;
        }

        @Override
        @Transient
        public final Builder replacementTemplate(ReplacementTemplate replacementTemplate) {
            this.replacementTemplate = replacementTemplate;
            return this;
        }

        @Override
        public ReplacementEmailContent build() {
            return new ReplacementEmailContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
