/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about email that was sent from the selected domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OverallVolume implements SdkPojo, Serializable, ToCopyableBuilder<OverallVolume.Builder, OverallVolume> {
    private static final SdkField<VolumeStatistics> VOLUME_STATISTICS_FIELD = SdkField
            .<VolumeStatistics> builder(MarshallingType.SDK_POJO).memberName("VolumeStatistics")
            .getter(getter(OverallVolume::volumeStatistics)).setter(setter(Builder::volumeStatistics))
            .constructor(VolumeStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeStatistics").build()).build();

    private static final SdkField<Double> READ_RATE_PERCENT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ReadRatePercent").getter(getter(OverallVolume::readRatePercent))
            .setter(setter(Builder::readRatePercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadRatePercent").build()).build();

    private static final SdkField<List<DomainIspPlacement>> DOMAIN_ISP_PLACEMENTS_FIELD = SdkField
            .<List<DomainIspPlacement>> builder(MarshallingType.LIST)
            .memberName("DomainIspPlacements")
            .getter(getter(OverallVolume::domainIspPlacements))
            .setter(setter(Builder::domainIspPlacements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIspPlacements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainIspPlacement> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainIspPlacement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_STATISTICS_FIELD,
            READ_RATE_PERCENT_FIELD, DOMAIN_ISP_PLACEMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final VolumeStatistics volumeStatistics;

    private final Double readRatePercent;

    private final List<DomainIspPlacement> domainIspPlacements;

    private OverallVolume(BuilderImpl builder) {
        this.volumeStatistics = builder.volumeStatistics;
        this.readRatePercent = builder.readRatePercent;
        this.domainIspPlacements = builder.domainIspPlacements;
    }

    /**
     * <p>
     * An object that contains information about the numbers of messages that arrived in recipients' inboxes and junk
     * mail folders.
     * </p>
     * 
     * @return An object that contains information about the numbers of messages that arrived in recipients' inboxes and
     *         junk mail folders.
     */
    public final VolumeStatistics volumeStatistics() {
        return volumeStatistics;
    }

    /**
     * <p>
     * The percentage of emails that were sent from the domain that were read by their recipients.
     * </p>
     * 
     * @return The percentage of emails that were sent from the domain that were read by their recipients.
     */
    public final Double readRatePercent() {
        return readRatePercent;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainIspPlacements property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainIspPlacements() {
        return domainIspPlacements != null && !(domainIspPlacements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains inbox and junk mail placement metrics for individual email providers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainIspPlacements} method.
     * </p>
     * 
     * @return An object that contains inbox and junk mail placement metrics for individual email providers.
     */
    public final List<DomainIspPlacement> domainIspPlacements() {
        return domainIspPlacements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(readRatePercent());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainIspPlacements() ? domainIspPlacements() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverallVolume)) {
            return false;
        }
        OverallVolume other = (OverallVolume) obj;
        return Objects.equals(volumeStatistics(), other.volumeStatistics())
                && Objects.equals(readRatePercent(), other.readRatePercent())
                && hasDomainIspPlacements() == other.hasDomainIspPlacements()
                && Objects.equals(domainIspPlacements(), other.domainIspPlacements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OverallVolume").add("VolumeStatistics", volumeStatistics())
                .add("ReadRatePercent", readRatePercent())
                .add("DomainIspPlacements", hasDomainIspPlacements() ? domainIspPlacements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeStatistics":
            return Optional.ofNullable(clazz.cast(volumeStatistics()));
        case "ReadRatePercent":
            return Optional.ofNullable(clazz.cast(readRatePercent()));
        case "DomainIspPlacements":
            return Optional.ofNullable(clazz.cast(domainIspPlacements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OverallVolume, T> g) {
        return obj -> g.apply((OverallVolume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OverallVolume> {
        /**
         * <p>
         * An object that contains information about the numbers of messages that arrived in recipients' inboxes and
         * junk mail folders.
         * </p>
         * 
         * @param volumeStatistics
         *        An object that contains information about the numbers of messages that arrived in recipients' inboxes
         *        and junk mail folders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeStatistics(VolumeStatistics volumeStatistics);

        /**
         * <p>
         * An object that contains information about the numbers of messages that arrived in recipients' inboxes and
         * junk mail folders.
         * </p>
         * This is a convenience that creates an instance of the {@link VolumeStatistics.Builder} avoiding the need to
         * create one manually via {@link VolumeStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link VolumeStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #volumeStatistics(VolumeStatistics)}.
         * 
         * @param volumeStatistics
         *        a consumer that will call methods on {@link VolumeStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeStatistics(VolumeStatistics)
         */
        default Builder volumeStatistics(Consumer<VolumeStatistics.Builder> volumeStatistics) {
            return volumeStatistics(VolumeStatistics.builder().applyMutation(volumeStatistics).build());
        }

        /**
         * <p>
         * The percentage of emails that were sent from the domain that were read by their recipients.
         * </p>
         * 
         * @param readRatePercent
         *        The percentage of emails that were sent from the domain that were read by their recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readRatePercent(Double readRatePercent);

        /**
         * <p>
         * An object that contains inbox and junk mail placement metrics for individual email providers.
         * </p>
         * 
         * @param domainIspPlacements
         *        An object that contains inbox and junk mail placement metrics for individual email providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIspPlacements(Collection<DomainIspPlacement> domainIspPlacements);

        /**
         * <p>
         * An object that contains inbox and junk mail placement metrics for individual email providers.
         * </p>
         * 
         * @param domainIspPlacements
         *        An object that contains inbox and junk mail placement metrics for individual email providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIspPlacements(DomainIspPlacement... domainIspPlacements);

        /**
         * <p>
         * An object that contains inbox and junk mail placement metrics for individual email providers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DomainIspPlacement>.Builder} avoiding the
         * need to create one manually via {@link List<DomainIspPlacement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainIspPlacement>.Builder#build()} is called immediately
         * and its result is passed to {@link #domainIspPlacements(List<DomainIspPlacement>)}.
         * 
         * @param domainIspPlacements
         *        a consumer that will call methods on {@link List<DomainIspPlacement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainIspPlacements(List<DomainIspPlacement>)
         */
        Builder domainIspPlacements(Consumer<DomainIspPlacement.Builder>... domainIspPlacements);
    }

    static final class BuilderImpl implements Builder {
        private VolumeStatistics volumeStatistics;

        private Double readRatePercent;

        private List<DomainIspPlacement> domainIspPlacements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OverallVolume model) {
            volumeStatistics(model.volumeStatistics);
            readRatePercent(model.readRatePercent);
            domainIspPlacements(model.domainIspPlacements);
        }

        public final VolumeStatistics.Builder getVolumeStatistics() {
            return volumeStatistics != null ? volumeStatistics.toBuilder() : null;
        }

        public final void setVolumeStatistics(VolumeStatistics.BuilderImpl volumeStatistics) {
            this.volumeStatistics = volumeStatistics != null ? volumeStatistics.build() : null;
        }

        @Override
        @Transient
        public final Builder volumeStatistics(VolumeStatistics volumeStatistics) {
            this.volumeStatistics = volumeStatistics;
            return this;
        }

        public final Double getReadRatePercent() {
            return readRatePercent;
        }

        public final void setReadRatePercent(Double readRatePercent) {
            this.readRatePercent = readRatePercent;
        }

        @Override
        @Transient
        public final Builder readRatePercent(Double readRatePercent) {
            this.readRatePercent = readRatePercent;
            return this;
        }

        public final List<DomainIspPlacement.Builder> getDomainIspPlacements() {
            List<DomainIspPlacement.Builder> result = DomainIspPlacementsCopier.copyToBuilder(this.domainIspPlacements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainIspPlacements(Collection<DomainIspPlacement.BuilderImpl> domainIspPlacements) {
            this.domainIspPlacements = DomainIspPlacementsCopier.copyFromBuilder(domainIspPlacements);
        }

        @Override
        @Transient
        public final Builder domainIspPlacements(Collection<DomainIspPlacement> domainIspPlacements) {
            this.domainIspPlacements = DomainIspPlacementsCopier.copy(domainIspPlacements);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainIspPlacements(DomainIspPlacement... domainIspPlacements) {
            domainIspPlacements(Arrays.asList(domainIspPlacements));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainIspPlacements(Consumer<DomainIspPlacement.Builder>... domainIspPlacements) {
            domainIspPlacements(Stream.of(domainIspPlacements).map(c -> DomainIspPlacement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public OverallVolume build() {
            return new OverallVolume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
