/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines the dimension configuration to use when you send email events to Amazon CloudWatch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchDimensionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchDimensionConfiguration.Builder, CloudWatchDimensionConfiguration> {
    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionName").getter(getter(CloudWatchDimensionConfiguration::dimensionName))
            .setter(setter(Builder::dimensionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionName").build()).build();

    private static final SdkField<String> DIMENSION_VALUE_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionValueSource").getter(getter(CloudWatchDimensionConfiguration::dimensionValueSourceAsString))
            .setter(setter(Builder::dimensionValueSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueSource").build())
            .build();

    private static final SdkField<String> DEFAULT_DIMENSION_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultDimensionValue").getter(getter(CloudWatchDimensionConfiguration::defaultDimensionValue))
            .setter(setter(Builder::defaultDimensionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultDimensionValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_NAME_FIELD,
            DIMENSION_VALUE_SOURCE_FIELD, DEFAULT_DIMENSION_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dimensionName;

    private final String dimensionValueSource;

    private final String defaultDimensionValue;

    private CloudWatchDimensionConfiguration(BuilderImpl builder) {
        this.dimensionName = builder.dimensionName;
        this.dimensionValueSource = builder.dimensionValueSource;
        this.defaultDimensionValue = builder.defaultDimensionValue;
    }

    /**
     * <p>
     * The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to meet the
     * following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
     * </p>
     * </li>
     * <li>
     * <p>
     * It can contain no more than 256 characters.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to meet
     *         the following criteria:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It can contain no more than 256 characters.
     *         </p>
     *         </li>
     */
    public final String dimensionName() {
        return dimensionName;
    }

    /**
     * <p>
     * The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. To use
     * the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the
     * <code>SendEmail</code> or <code>SendRawEmail</code> API, choose <code>messageTag</code>. To use your own email
     * headers, choose <code>emailHeader</code>. To use link tags, choose <code>linkTags</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dimensionValueSource} will return {@link DimensionValueSource#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dimensionValueSourceAsString}.
     * </p>
     * 
     * @return The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch.
     *         To use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter
     *         to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose <code>messageTag</code>. To use
     *         your own email headers, choose <code>emailHeader</code>. To use link tags, choose <code>linkTags</code>.
     * @see DimensionValueSource
     */
    public final DimensionValueSource dimensionValueSource() {
        return DimensionValueSource.fromValue(dimensionValueSource);
    }

    /**
     * <p>
     * The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. To use
     * the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the
     * <code>SendEmail</code> or <code>SendRawEmail</code> API, choose <code>messageTag</code>. To use your own email
     * headers, choose <code>emailHeader</code>. To use link tags, choose <code>linkTags</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dimensionValueSource} will return {@link DimensionValueSource#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dimensionValueSourceAsString}.
     * </p>
     * 
     * @return The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch.
     *         To use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter
     *         to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose <code>messageTag</code>. To use
     *         your own email headers, choose <code>emailHeader</code>. To use link tags, choose <code>linkTags</code>.
     * @see DimensionValueSource
     */
    public final String dimensionValueSourceAsString() {
        return dimensionValueSource;
    }

    /**
     * <p>
     * The default value of the dimension that is published to Amazon CloudWatch if you don't provide the value of the
     * dimension when you send an email. This value has to meet the following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
     * </p>
     * </li>
     * <li>
     * <p>
     * It can contain no more than 256 characters.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The default value of the dimension that is published to Amazon CloudWatch if you don't provide the value
     *         of the dimension when you send an email. This value has to meet the following criteria:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It can contain no more than 256 characters.
     *         </p>
     *         </li>
     */
    public final String defaultDimensionValue() {
        return defaultDimensionValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionName());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionValueSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultDimensionValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchDimensionConfiguration)) {
            return false;
        }
        CloudWatchDimensionConfiguration other = (CloudWatchDimensionConfiguration) obj;
        return Objects.equals(dimensionName(), other.dimensionName())
                && Objects.equals(dimensionValueSourceAsString(), other.dimensionValueSourceAsString())
                && Objects.equals(defaultDimensionValue(), other.defaultDimensionValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchDimensionConfiguration").add("DimensionName", dimensionName())
                .add("DimensionValueSource", dimensionValueSourceAsString())
                .add("DefaultDimensionValue", defaultDimensionValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionName":
            return Optional.ofNullable(clazz.cast(dimensionName()));
        case "DimensionValueSource":
            return Optional.ofNullable(clazz.cast(dimensionValueSourceAsString()));
        case "DefaultDimensionValue":
            return Optional.ofNullable(clazz.cast(defaultDimensionValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchDimensionConfiguration, T> g) {
        return obj -> g.apply((CloudWatchDimensionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchDimensionConfiguration> {
        /**
         * <p>
         * The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to meet the
         * following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
         * </p>
         * </li>
         * <li>
         * <p>
         * It can contain no more than 256 characters.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dimensionName
         *        The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to
         *        meet the following criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It can contain no more than 256 characters.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionName(String dimensionName);

        /**
         * <p>
         * The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. To
         * use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the
         * <code>SendEmail</code> or <code>SendRawEmail</code> API, choose <code>messageTag</code>. To use your own
         * email headers, choose <code>emailHeader</code>. To use link tags, choose <code>linkTags</code>.
         * </p>
         * 
         * @param dimensionValueSource
         *        The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon
         *        CloudWatch. To use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header
         *        or a parameter to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose
         *        <code>messageTag</code>. To use your own email headers, choose <code>emailHeader</code>. To use link
         *        tags, choose <code>linkTags</code>.
         * @see DimensionValueSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionValueSource
         */
        Builder dimensionValueSource(String dimensionValueSource);

        /**
         * <p>
         * The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. To
         * use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the
         * <code>SendEmail</code> or <code>SendRawEmail</code> API, choose <code>messageTag</code>. To use your own
         * email headers, choose <code>emailHeader</code>. To use link tags, choose <code>linkTags</code>.
         * </p>
         * 
         * @param dimensionValueSource
         *        The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon
         *        CloudWatch. To use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header
         *        or a parameter to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose
         *        <code>messageTag</code>. To use your own email headers, choose <code>emailHeader</code>. To use link
         *        tags, choose <code>linkTags</code>.
         * @see DimensionValueSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DimensionValueSource
         */
        Builder dimensionValueSource(DimensionValueSource dimensionValueSource);

        /**
         * <p>
         * The default value of the dimension that is published to Amazon CloudWatch if you don't provide the value of
         * the dimension when you send an email. This value has to meet the following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
         * </p>
         * </li>
         * <li>
         * <p>
         * It can contain no more than 256 characters.
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultDimensionValue
         *        The default value of the dimension that is published to Amazon CloudWatch if you don't provide the
         *        value of the dimension when you send an email. This value has to meet the following criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It can contain no more than 256 characters.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDimensionValue(String defaultDimensionValue);
    }

    static final class BuilderImpl implements Builder {
        private String dimensionName;

        private String dimensionValueSource;

        private String defaultDimensionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchDimensionConfiguration model) {
            dimensionName(model.dimensionName);
            dimensionValueSource(model.dimensionValueSource);
            defaultDimensionValue(model.defaultDimensionValue);
        }

        public final String getDimensionName() {
            return dimensionName;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @Override
        @Transient
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public final String getDimensionValueSource() {
            return dimensionValueSource;
        }

        public final void setDimensionValueSource(String dimensionValueSource) {
            this.dimensionValueSource = dimensionValueSource;
        }

        @Override
        @Transient
        public final Builder dimensionValueSource(String dimensionValueSource) {
            this.dimensionValueSource = dimensionValueSource;
            return this;
        }

        @Override
        @Transient
        public final Builder dimensionValueSource(DimensionValueSource dimensionValueSource) {
            this.dimensionValueSource(dimensionValueSource == null ? null : dimensionValueSource.toString());
            return this;
        }

        public final String getDefaultDimensionValue() {
            return defaultDimensionValue;
        }

        public final void setDefaultDimensionValue(String defaultDimensionValue) {
            this.defaultDimensionValue = defaultDimensionValue;
        }

        @Override
        @Transient
        public final Builder defaultDimensionValue(String defaultDimensionValue) {
            this.defaultDimensionValue = defaultDimensionValue;
            return this;
        }

        @Override
        public CloudWatchDimensionConfiguration build() {
            return new CloudWatchDimensionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
