/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to update the event destination of a configuration set. Configuration sets enable you to publish
 * email sending events. For information about using configuration sets, see the <a
 * href="https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html">Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigurationSetEventDestinationRequest extends SesRequest implements
        ToCopyableBuilder<UpdateConfigurationSetEventDestinationRequest.Builder, UpdateConfigurationSetEventDestinationRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName")
            .getter(getter(UpdateConfigurationSetEventDestinationRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<EventDestination> EVENT_DESTINATION_FIELD = SdkField
            .<EventDestination> builder(MarshallingType.SDK_POJO).memberName("EventDestination")
            .getter(getter(UpdateConfigurationSetEventDestinationRequest::eventDestination))
            .setter(setter(Builder::eventDestination)).constructor(EventDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            EVENT_DESTINATION_FIELD));

    private final String configurationSetName;

    private final EventDestination eventDestination;

    private UpdateConfigurationSetEventDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.eventDestination = builder.eventDestination;
    }

    /**
     * <p>
     * The name of the configuration set that contains the event destination.
     * </p>
     * 
     * @return The name of the configuration set that contains the event destination.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The event destination object.
     * </p>
     * 
     * @return The event destination object.
     */
    public final EventDestination eventDestination() {
        return eventDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(eventDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationSetEventDestinationRequest)) {
            return false;
        }
        UpdateConfigurationSetEventDestinationRequest other = (UpdateConfigurationSetEventDestinationRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(eventDestination(), other.eventDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfigurationSetEventDestinationRequest")
                .add("ConfigurationSetName", configurationSetName()).add("EventDestination", eventDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "EventDestination":
            return Optional.ofNullable(clazz.cast(eventDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationSetEventDestinationRequest, T> g) {
        return obj -> g.apply((UpdateConfigurationSetEventDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConfigurationSetEventDestinationRequest> {
        /**
         * <p>
         * The name of the configuration set that contains the event destination.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set that contains the event destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The event destination object.
         * </p>
         * 
         * @param eventDestination
         *        The event destination object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestination(EventDestination eventDestination);

        /**
         * <p>
         * The event destination object.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventDestination.Builder} avoiding the
         * need to create one manually via {@link EventDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #eventDestination(EventDestination)}.
         * 
         * @param eventDestination
         *        a consumer that will call methods on {@link EventDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventDestination(EventDestination)
         */
        default Builder eventDestination(Consumer<EventDestination.Builder> eventDestination) {
            return eventDestination(EventDestination.builder().applyMutation(eventDestination).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String configurationSetName;

        private EventDestination eventDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationSetEventDestinationRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            eventDestination(model.eventDestination);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final EventDestination.Builder getEventDestination() {
            return eventDestination != null ? eventDestination.toBuilder() : null;
        }

        public final void setEventDestination(EventDestination.BuilderImpl eventDestination) {
            this.eventDestination = eventDestination != null ? eventDestination.build() : null;
        }

        @Override
        public final Builder eventDestination(EventDestination eventDestination) {
            this.eventDestination = eventDestination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationSetEventDestinationRequest build() {
            return new UpdateConfigurationSetEventDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
