/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigurationSetAttribute {
    EVENT_DESTINATIONS("eventDestinations"),
    TRACKING_OPTIONS("trackingOptions"),
    DELIVERY_OPTIONS("deliveryOptions"),
    REPUTATION_OPTIONS("reputationOptions"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigurationSetAttribute> VALUE_MAP;
    private final String value;

    private ConfigurationSetAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationSetAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationSetAttribute> knownValues() {
        EnumSet<ConfigurationSetAttribute> knownValues = EnumSet.allOf(ConfigurationSetAttribute.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigurationSetAttribute.class, ConfigurationSetAttribute::toString);
    }
}

