/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the custom MAIL FROM domain attributes of a verified identity (email address or domain).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityMailFromDomainAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityMailFromDomainAttributes.Builder, IdentityMailFromDomainAttributes> {
    private static final SdkField<String> MAIL_FROM_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MailFromDomain").getter(getter(IdentityMailFromDomainAttributes::mailFromDomain))
            .setter(setter(Builder::mailFromDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromDomain").build()).build();

    private static final SdkField<String> MAIL_FROM_DOMAIN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MailFromDomainStatus").getter(getter(IdentityMailFromDomainAttributes::mailFromDomainStatusAsString))
            .setter(setter(Builder::mailFromDomainStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromDomainStatus").build())
            .build();

    private static final SdkField<String> BEHAVIOR_ON_MX_FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BehaviorOnMXFailure").getter(getter(IdentityMailFromDomainAttributes::behaviorOnMXFailureAsString))
            .setter(setter(Builder::behaviorOnMXFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BehaviorOnMXFailure").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAIL_FROM_DOMAIN_FIELD,
            MAIL_FROM_DOMAIN_STATUS_FIELD, BEHAVIOR_ON_MX_FAILURE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mailFromDomain;

    private final String mailFromDomainStatus;

    private final String behaviorOnMXFailure;

    private IdentityMailFromDomainAttributes(BuilderImpl builder) {
        this.mailFromDomain = builder.mailFromDomain;
        this.mailFromDomainStatus = builder.mailFromDomainStatus;
        this.behaviorOnMXFailure = builder.behaviorOnMXFailure;
    }

    /**
     * <p>
     * The custom MAIL FROM domain that the identity is configured to use.
     * </p>
     * 
     * @return The custom MAIL FROM domain that the identity is configured to use.
     */
    public final String mailFromDomain() {
        return mailFromDomain;
    }

    /**
     * <p>
     * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM
     * domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM domain when
     * the verified identity sends an email. All other states indicate that Amazon SES takes the action described by
     * <code>BehaviorOnMXFailure</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mailFromDomainStatus} will return {@link CustomMailFromStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mailFromDomainStatusAsString}.
     * </p>
     * 
     * @return The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL
     *         FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM
     *         domain when the verified identity sends an email. All other states indicate that Amazon SES takes the
     *         action described by <code>BehaviorOnMXFailure</code>.
     * @see CustomMailFromStatus
     */
    public final CustomMailFromStatus mailFromDomainStatus() {
        return CustomMailFromStatus.fromValue(mailFromDomainStatus);
    }

    /**
     * <p>
     * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM
     * domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM domain when
     * the verified identity sends an email. All other states indicate that Amazon SES takes the action described by
     * <code>BehaviorOnMXFailure</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mailFromDomainStatus} will return {@link CustomMailFromStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mailFromDomainStatusAsString}.
     * </p>
     * 
     * @return The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL
     *         FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM
     *         domain when the verified identity sends an email. All other states indicate that Amazon SES takes the
     *         action described by <code>BehaviorOnMXFailure</code>.
     * @see CustomMailFromStatus
     */
    public final String mailFromDomainStatusAsString() {
        return mailFromDomainStatus;
    }

    /**
     * <p>
     * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an email. A
     * value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX record, it uses
     * amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of <code>RejectMessage</code> indicates
     * that if Amazon SES cannot read the required MX record, Amazon SES returns a
     * <code>MailFromDomainNotVerified</code> error and does not send the email.
     * </p>
     * <p>
     * The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>, <code>Failed</code>, and
     * <code>TemporaryFailure</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #behaviorOnMXFailure} will return {@link BehaviorOnMXFailure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #behaviorOnMXFailureAsString}.
     * </p>
     * 
     * @return The action that Amazon SES takes if it cannot successfully read the required MX record when you send an
     *         email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX
     *         record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
     *         <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
     *         returns a <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
     *         <p>
     *         The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>,
     *         <code>Failed</code>, and <code>TemporaryFailure</code>.
     * @see BehaviorOnMXFailure
     */
    public final BehaviorOnMXFailure behaviorOnMXFailure() {
        return BehaviorOnMXFailure.fromValue(behaviorOnMXFailure);
    }

    /**
     * <p>
     * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an email. A
     * value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX record, it uses
     * amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of <code>RejectMessage</code> indicates
     * that if Amazon SES cannot read the required MX record, Amazon SES returns a
     * <code>MailFromDomainNotVerified</code> error and does not send the email.
     * </p>
     * <p>
     * The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>, <code>Failed</code>, and
     * <code>TemporaryFailure</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #behaviorOnMXFailure} will return {@link BehaviorOnMXFailure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #behaviorOnMXFailureAsString}.
     * </p>
     * 
     * @return The action that Amazon SES takes if it cannot successfully read the required MX record when you send an
     *         email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX
     *         record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
     *         <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
     *         returns a <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
     *         <p>
     *         The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>,
     *         <code>Failed</code>, and <code>TemporaryFailure</code>.
     * @see BehaviorOnMXFailure
     */
    public final String behaviorOnMXFailureAsString() {
        return behaviorOnMXFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mailFromDomain());
        hashCode = 31 * hashCode + Objects.hashCode(mailFromDomainStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(behaviorOnMXFailureAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityMailFromDomainAttributes)) {
            return false;
        }
        IdentityMailFromDomainAttributes other = (IdentityMailFromDomainAttributes) obj;
        return Objects.equals(mailFromDomain(), other.mailFromDomain())
                && Objects.equals(mailFromDomainStatusAsString(), other.mailFromDomainStatusAsString())
                && Objects.equals(behaviorOnMXFailureAsString(), other.behaviorOnMXFailureAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityMailFromDomainAttributes").add("MailFromDomain", mailFromDomain())
                .add("MailFromDomainStatus", mailFromDomainStatusAsString())
                .add("BehaviorOnMXFailure", behaviorOnMXFailureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MailFromDomain":
            return Optional.ofNullable(clazz.cast(mailFromDomain()));
        case "MailFromDomainStatus":
            return Optional.ofNullable(clazz.cast(mailFromDomainStatusAsString()));
        case "BehaviorOnMXFailure":
            return Optional.ofNullable(clazz.cast(behaviorOnMXFailureAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityMailFromDomainAttributes, T> g) {
        return obj -> g.apply((IdentityMailFromDomainAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityMailFromDomainAttributes> {
        /**
         * <p>
         * The custom MAIL FROM domain that the identity is configured to use.
         * </p>
         * 
         * @param mailFromDomain
         *        The custom MAIL FROM domain that the identity is configured to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailFromDomain(String mailFromDomain);

        /**
         * <p>
         * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM
         * domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM domain
         * when the verified identity sends an email. All other states indicate that Amazon SES takes the action
         * described by <code>BehaviorOnMXFailure</code>.
         * </p>
         * 
         * @param mailFromDomainStatus
         *        The state that indicates whether Amazon SES has successfully read the MX record required for custom
         *        MAIL FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom
         *        MAIL FROM domain when the verified identity sends an email. All other states indicate that Amazon SES
         *        takes the action described by <code>BehaviorOnMXFailure</code>.
         * @see CustomMailFromStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomMailFromStatus
         */
        Builder mailFromDomainStatus(String mailFromDomainStatus);

        /**
         * <p>
         * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM
         * domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM domain
         * when the verified identity sends an email. All other states indicate that Amazon SES takes the action
         * described by <code>BehaviorOnMXFailure</code>.
         * </p>
         * 
         * @param mailFromDomainStatus
         *        The state that indicates whether Amazon SES has successfully read the MX record required for custom
         *        MAIL FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom
         *        MAIL FROM domain when the verified identity sends an email. All other states indicate that Amazon SES
         *        takes the action described by <code>BehaviorOnMXFailure</code>.
         * @see CustomMailFromStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomMailFromStatus
         */
        Builder mailFromDomainStatus(CustomMailFromStatus mailFromDomainStatus);

        /**
         * <p>
         * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an
         * email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX
         * record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
         * <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
         * returns a <code>MailFromDomainNotVerified</code> error and does not send the email.
         * </p>
         * <p>
         * The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>, <code>Failed</code>,
         * and <code>TemporaryFailure</code>.
         * </p>
         * 
         * @param behaviorOnMXFailure
         *        The action that Amazon SES takes if it cannot successfully read the required MX record when you send
         *        an email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the
         *        required MX record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
         *        <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
         *        returns a <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
         *        <p>
         *        The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>,
         *        <code>Failed</code>, and <code>TemporaryFailure</code>.
         * @see BehaviorOnMXFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorOnMXFailure
         */
        Builder behaviorOnMXFailure(String behaviorOnMXFailure);

        /**
         * <p>
         * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an
         * email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX
         * record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
         * <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
         * returns a <code>MailFromDomainNotVerified</code> error and does not send the email.
         * </p>
         * <p>
         * The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>, <code>Failed</code>,
         * and <code>TemporaryFailure</code>.
         * </p>
         * 
         * @param behaviorOnMXFailure
         *        The action that Amazon SES takes if it cannot successfully read the required MX record when you send
         *        an email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the
         *        required MX record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
         *        <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
         *        returns a <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
         *        <p>
         *        The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>,
         *        <code>Failed</code>, and <code>TemporaryFailure</code>.
         * @see BehaviorOnMXFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorOnMXFailure
         */
        Builder behaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure);
    }

    static final class BuilderImpl implements Builder {
        private String mailFromDomain;

        private String mailFromDomainStatus;

        private String behaviorOnMXFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityMailFromDomainAttributes model) {
            mailFromDomain(model.mailFromDomain);
            mailFromDomainStatus(model.mailFromDomainStatus);
            behaviorOnMXFailure(model.behaviorOnMXFailure);
        }

        public final String getMailFromDomain() {
            return mailFromDomain;
        }

        @Override
        public final Builder mailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
            return this;
        }

        public final void setMailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
        }

        public final String getMailFromDomainStatus() {
            return mailFromDomainStatus;
        }

        @Override
        public final Builder mailFromDomainStatus(String mailFromDomainStatus) {
            this.mailFromDomainStatus = mailFromDomainStatus;
            return this;
        }

        @Override
        public final Builder mailFromDomainStatus(CustomMailFromStatus mailFromDomainStatus) {
            this.mailFromDomainStatus(mailFromDomainStatus == null ? null : mailFromDomainStatus.toString());
            return this;
        }

        public final void setMailFromDomainStatus(String mailFromDomainStatus) {
            this.mailFromDomainStatus = mailFromDomainStatus;
        }

        public final String getBehaviorOnMXFailure() {
            return behaviorOnMXFailure;
        }

        @Override
        public final Builder behaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
            return this;
        }

        @Override
        public final Builder behaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure) {
            this.behaviorOnMXFailure(behaviorOnMXFailure == null ? null : behaviorOnMXFailure.toString());
            return this;
        }

        public final void setBehaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
        }

        @Override
        public IdentityMailFromDomainAttributes build() {
            return new IdentityMailFromDomainAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
