/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuotaUtilizationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuotaUtilizationInfo> {
    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaCode").getter(QuotaUtilizationInfo.getter(QuotaUtilizationInfo::quotaCode)).setter(QuotaUtilizationInfo.setter(Builder::quotaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()}).build();
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceCode").getter(QuotaUtilizationInfo.getter(QuotaUtilizationInfo::serviceCode)).setter(QuotaUtilizationInfo.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()}).build();
    private static final SdkField<String> QUOTA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaName").getter(QuotaUtilizationInfo.getter(QuotaUtilizationInfo::quotaName)).setter(QuotaUtilizationInfo.setter(Builder::quotaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaName").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(QuotaUtilizationInfo.getter(QuotaUtilizationInfo::namespace)).setter(QuotaUtilizationInfo.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<Double> UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Utilization").getter(QuotaUtilizationInfo.getter(QuotaUtilizationInfo::utilization)).setter(QuotaUtilizationInfo.setter(Builder::utilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Utilization").build()}).build();
    private static final SdkField<Double> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DefaultValue").getter(QuotaUtilizationInfo.getter(QuotaUtilizationInfo::defaultValue)).setter(QuotaUtilizationInfo.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<Double> APPLIED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AppliedValue").getter(QuotaUtilizationInfo.getter(QuotaUtilizationInfo::appliedValue)).setter(QuotaUtilizationInfo.setter(Builder::appliedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedValue").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(QuotaUtilizationInfo.getter(QuotaUtilizationInfo::serviceName)).setter(QuotaUtilizationInfo.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<Boolean> ADJUSTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Adjustable").getter(QuotaUtilizationInfo.getter(QuotaUtilizationInfo::adjustable)).setter(QuotaUtilizationInfo.setter(Builder::adjustable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Adjustable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUOTA_CODE_FIELD, SERVICE_CODE_FIELD, QUOTA_NAME_FIELD, NAMESPACE_FIELD, UTILIZATION_FIELD, DEFAULT_VALUE_FIELD, APPLIED_VALUE_FIELD, SERVICE_NAME_FIELD, ADJUSTABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QuotaUtilizationInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String quotaCode;
    private final String serviceCode;
    private final String quotaName;
    private final String namespace;
    private final Double utilization;
    private final Double defaultValue;
    private final Double appliedValue;
    private final String serviceName;
    private final Boolean adjustable;

    private QuotaUtilizationInfo(BuilderImpl builder) {
        this.quotaCode = builder.quotaCode;
        this.serviceCode = builder.serviceCode;
        this.quotaName = builder.quotaName;
        this.namespace = builder.namespace;
        this.utilization = builder.utilization;
        this.defaultValue = builder.defaultValue;
        this.appliedValue = builder.appliedValue;
        this.serviceName = builder.serviceName;
        this.adjustable = builder.adjustable;
    }

    public final String quotaCode() {
        return this.quotaCode;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String quotaName() {
        return this.quotaName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final Double utilization() {
        return this.utilization;
    }

    public final Double defaultValue() {
        return this.defaultValue;
    }

    public final Double appliedValue() {
        return this.appliedValue;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final Boolean adjustable() {
        return this.adjustable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.utilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.adjustable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuotaUtilizationInfo)) {
            return false;
        }
        QuotaUtilizationInfo other = (QuotaUtilizationInfo)obj;
        return Objects.equals(this.quotaCode(), other.quotaCode()) && Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.quotaName(), other.quotaName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.utilization(), other.utilization()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.appliedValue(), other.appliedValue()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.adjustable(), other.adjustable());
    }

    public final String toString() {
        return ToString.builder((String)"QuotaUtilizationInfo").add("QuotaCode", (Object)this.quotaCode()).add("ServiceCode", (Object)this.serviceCode()).add("QuotaName", (Object)this.quotaName()).add("Namespace", (Object)this.namespace()).add("Utilization", (Object)this.utilization()).add("DefaultValue", (Object)this.defaultValue()).add("AppliedValue", (Object)this.appliedValue()).add("ServiceName", (Object)this.serviceName()).add("Adjustable", (Object)this.adjustable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuotaCode": {
                return Optional.ofNullable(clazz.cast(this.quotaCode()));
            }
            case "ServiceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "QuotaName": {
                return Optional.ofNullable(clazz.cast(this.quotaName()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Utilization": {
                return Optional.ofNullable(clazz.cast(this.utilization()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "AppliedValue": {
                return Optional.ofNullable(clazz.cast(this.appliedValue()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "Adjustable": {
                return Optional.ofNullable(clazz.cast(this.adjustable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QuotaCode", QUOTA_CODE_FIELD);
        map.put("ServiceCode", SERVICE_CODE_FIELD);
        map.put("QuotaName", QUOTA_NAME_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("Utilization", UTILIZATION_FIELD);
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("AppliedValue", APPLIED_VALUE_FIELD);
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("Adjustable", ADJUSTABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuotaUtilizationInfo, T> g) {
        return obj -> g.apply((QuotaUtilizationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String quotaCode;
        private String serviceCode;
        private String quotaName;
        private String namespace;
        private Double utilization;
        private Double defaultValue;
        private Double appliedValue;
        private String serviceName;
        private Boolean adjustable;

        private BuilderImpl() {
        }

        private BuilderImpl(QuotaUtilizationInfo model) {
            this.quotaCode(model.quotaCode);
            this.serviceCode(model.serviceCode);
            this.quotaName(model.quotaName);
            this.namespace(model.namespace);
            this.utilization(model.utilization);
            this.defaultValue(model.defaultValue);
            this.appliedValue(model.appliedValue);
            this.serviceName(model.serviceName);
            this.adjustable(model.adjustable);
        }

        public final String getQuotaCode() {
            return this.quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getQuotaName() {
            return this.quotaName;
        }

        public final void setQuotaName(String quotaName) {
            this.quotaName = quotaName;
        }

        @Override
        public final Builder quotaName(String quotaName) {
            this.quotaName = quotaName;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final Double getUtilization() {
            return this.utilization;
        }

        public final void setUtilization(Double utilization) {
            this.utilization = utilization;
        }

        @Override
        public final Builder utilization(Double utilization) {
            this.utilization = utilization;
            return this;
        }

        public final Double getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Double getAppliedValue() {
            return this.appliedValue;
        }

        public final void setAppliedValue(Double appliedValue) {
            this.appliedValue = appliedValue;
        }

        @Override
        public final Builder appliedValue(Double appliedValue) {
            this.appliedValue = appliedValue;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final Boolean getAdjustable() {
            return this.adjustable;
        }

        public final void setAdjustable(Boolean adjustable) {
            this.adjustable = adjustable;
        }

        @Override
        public final Builder adjustable(Boolean adjustable) {
            this.adjustable = adjustable;
            return this;
        }

        public QuotaUtilizationInfo build() {
            return new QuotaUtilizationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuotaUtilizationInfo> {
        public Builder quotaCode(String var1);

        public Builder serviceCode(String var1);

        public Builder quotaName(String var1);

        public Builder namespace(String var1);

        public Builder utilization(Double var1);

        public Builder defaultValue(Double var1);

        public Builder appliedValue(Double var1);

        public Builder serviceName(String var1);

        public Builder adjustable(Boolean var1);
    }
}

