/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServiceQuotaRequest
extends ServiceQuotasRequest
implements ToCopyableBuilder<Builder, GetServiceQuotaRequest> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceCode").getter(GetServiceQuotaRequest.getter(GetServiceQuotaRequest::serviceCode)).setter(GetServiceQuotaRequest.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()}).build();
    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaCode").getter(GetServiceQuotaRequest.getter(GetServiceQuotaRequest::quotaCode)).setter(GetServiceQuotaRequest.setter(Builder::quotaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()}).build();
    private static final SdkField<String> CONTEXT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContextId").getter(GetServiceQuotaRequest.getter(GetServiceQuotaRequest::contextId)).setter(GetServiceQuotaRequest.setter(Builder::contextId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD, QUOTA_CODE_FIELD, CONTEXT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetServiceQuotaRequest.memberNameToFieldInitializer();
    private final String serviceCode;
    private final String quotaCode;
    private final String contextId;

    private GetServiceQuotaRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCode = builder.serviceCode;
        this.quotaCode = builder.quotaCode;
        this.contextId = builder.contextId;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String quotaCode() {
        return this.quotaCode;
    }

    public final String contextId() {
        return this.contextId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceQuotaRequest)) {
            return false;
        }
        GetServiceQuotaRequest other = (GetServiceQuotaRequest)((Object)obj);
        return Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.quotaCode(), other.quotaCode()) && Objects.equals(this.contextId(), other.contextId());
    }

    public final String toString() {
        return ToString.builder((String)"GetServiceQuotaRequest").add("ServiceCode", (Object)this.serviceCode()).add("QuotaCode", (Object)this.quotaCode()).add("ContextId", (Object)this.contextId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "QuotaCode": {
                return Optional.ofNullable(clazz.cast(this.quotaCode()));
            }
            case "ContextId": {
                return Optional.ofNullable(clazz.cast(this.contextId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ServiceCode", SERVICE_CODE_FIELD);
        map.put("QuotaCode", QUOTA_CODE_FIELD);
        map.put("ContextId", CONTEXT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServiceQuotaRequest, T> g) {
        return obj -> g.apply((GetServiceQuotaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceQuotasRequest.BuilderImpl
    implements Builder {
        private String serviceCode;
        private String quotaCode;
        private String contextId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceQuotaRequest model) {
            super(model);
            this.serviceCode(model.serviceCode);
            this.quotaCode(model.quotaCode);
            this.contextId(model.contextId);
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getQuotaCode() {
            return this.quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final String getContextId() {
            return this.contextId;
        }

        public final void setContextId(String contextId) {
            this.contextId = contextId;
        }

        @Override
        public final Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetServiceQuotaRequest build() {
            return new GetServiceQuotaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceQuotasRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServiceQuotaRequest> {
        public Builder serviceCode(String var1);

        public Builder quotaCode(String var1);

        public Builder contextId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

