/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicequotas.model.QuotaUtilizationInfo;
import software.amazon.awssdk.services.servicequotas.model.QuotaUtilizationInfoListCopier;
import software.amazon.awssdk.services.servicequotas.model.ReportStatus;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQuotaUtilizationReportResponse
extends ServiceQuotasResponse
implements ToCopyableBuilder<Builder, GetQuotaUtilizationReportResponse> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportId").getter(GetQuotaUtilizationReportResponse.getter(GetQuotaUtilizationReportResponse::reportId)).setter(GetQuotaUtilizationReportResponse.setter(Builder::reportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetQuotaUtilizationReportResponse.getter(GetQuotaUtilizationReportResponse::statusAsString)).setter(GetQuotaUtilizationReportResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> GENERATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("GeneratedAt").getter(GetQuotaUtilizationReportResponse.getter(GetQuotaUtilizationReportResponse::generatedAt)).setter(GetQuotaUtilizationReportResponse.setter(Builder::generatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedAt").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCount").getter(GetQuotaUtilizationReportResponse.getter(GetQuotaUtilizationReportResponse::totalCount)).setter(GetQuotaUtilizationReportResponse.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final SdkField<List<QuotaUtilizationInfo>> QUOTAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Quotas").getter(GetQuotaUtilizationReportResponse.getter(GetQuotaUtilizationReportResponse::quotas)).setter(GetQuotaUtilizationReportResponse.setter(Builder::quotas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quotas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuotaUtilizationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetQuotaUtilizationReportResponse.getter(GetQuotaUtilizationReportResponse::nextToken)).setter(GetQuotaUtilizationReportResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(GetQuotaUtilizationReportResponse.getter(GetQuotaUtilizationReportResponse::errorCode)).setter(GetQuotaUtilizationReportResponse.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(GetQuotaUtilizationReportResponse.getter(GetQuotaUtilizationReportResponse::errorMessage)).setter(GetQuotaUtilizationReportResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD, STATUS_FIELD, GENERATED_AT_FIELD, TOTAL_COUNT_FIELD, QUOTAS_FIELD, NEXT_TOKEN_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetQuotaUtilizationReportResponse.memberNameToFieldInitializer();
    private final String reportId;
    private final String status;
    private final Instant generatedAt;
    private final Integer totalCount;
    private final List<QuotaUtilizationInfo> quotas;
    private final String nextToken;
    private final String errorCode;
    private final String errorMessage;

    private GetQuotaUtilizationReportResponse(BuilderImpl builder) {
        super(builder);
        this.reportId = builder.reportId;
        this.status = builder.status;
        this.generatedAt = builder.generatedAt;
        this.totalCount = builder.totalCount;
        this.quotas = builder.quotas;
        this.nextToken = builder.nextToken;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public final String reportId() {
        return this.reportId;
    }

    public final ReportStatus status() {
        return ReportStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant generatedAt() {
        return this.generatedAt;
    }

    public final Integer totalCount() {
        return this.totalCount;
    }

    public final boolean hasQuotas() {
        return this.quotas != null && !(this.quotas instanceof SdkAutoConstructList);
    }

    public final List<QuotaUtilizationInfo> quotas() {
        return this.quotas;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuotas() ? this.quotas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQuotaUtilizationReportResponse)) {
            return false;
        }
        GetQuotaUtilizationReportResponse other = (GetQuotaUtilizationReportResponse)((Object)obj);
        return Objects.equals(this.reportId(), other.reportId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.generatedAt(), other.generatedAt()) && Objects.equals(this.totalCount(), other.totalCount()) && this.hasQuotas() == other.hasQuotas() && Objects.equals(this.quotas(), other.quotas()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"GetQuotaUtilizationReportResponse").add("ReportId", (Object)this.reportId()).add("Status", (Object)this.statusAsString()).add("GeneratedAt", (Object)this.generatedAt()).add("TotalCount", (Object)this.totalCount()).add("Quotas", this.hasQuotas() ? this.quotas() : null).add("NextToken", (Object)this.nextToken()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportId": {
                return Optional.ofNullable(clazz.cast(this.reportId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "GeneratedAt": {
                return Optional.ofNullable(clazz.cast(this.generatedAt()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
            case "Quotas": {
                return Optional.ofNullable(clazz.cast(this.quotas()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReportId", REPORT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("GeneratedAt", GENERATED_AT_FIELD);
        map.put("TotalCount", TOTAL_COUNT_FIELD);
        map.put("Quotas", QUOTAS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQuotaUtilizationReportResponse, T> g) {
        return obj -> g.apply((GetQuotaUtilizationReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceQuotasResponse.BuilderImpl
    implements Builder {
        private String reportId;
        private String status;
        private Instant generatedAt;
        private Integer totalCount;
        private List<QuotaUtilizationInfo> quotas = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQuotaUtilizationReportResponse model) {
            super(model);
            this.reportId(model.reportId);
            this.status(model.status);
            this.generatedAt(model.generatedAt);
            this.totalCount(model.totalCount);
            this.quotas(model.quotas);
            this.nextToken(model.nextToken);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getGeneratedAt() {
            return this.generatedAt;
        }

        public final void setGeneratedAt(Instant generatedAt) {
            this.generatedAt = generatedAt;
        }

        @Override
        public final Builder generatedAt(Instant generatedAt) {
            this.generatedAt = generatedAt;
            return this;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final List<QuotaUtilizationInfo.Builder> getQuotas() {
            List<QuotaUtilizationInfo.Builder> result = QuotaUtilizationInfoListCopier.copyToBuilder(this.quotas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuotas(Collection<QuotaUtilizationInfo.BuilderImpl> quotas) {
            this.quotas = QuotaUtilizationInfoListCopier.copyFromBuilder(quotas);
        }

        @Override
        public final Builder quotas(Collection<QuotaUtilizationInfo> quotas) {
            this.quotas = QuotaUtilizationInfoListCopier.copy(quotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quotas(QuotaUtilizationInfo ... quotas) {
            this.quotas(Arrays.asList(quotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quotas(Consumer<QuotaUtilizationInfo.Builder> ... quotas) {
            this.quotas(Stream.of(quotas).map(c -> (QuotaUtilizationInfo)((QuotaUtilizationInfo.Builder)QuotaUtilizationInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public GetQuotaUtilizationReportResponse build() {
            return new GetQuotaUtilizationReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceQuotasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQuotaUtilizationReportResponse> {
        public Builder reportId(String var1);

        public Builder status(String var1);

        public Builder status(ReportStatus var1);

        public Builder generatedAt(Instant var1);

        public Builder totalCount(Integer var1);

        public Builder quotas(Collection<QuotaUtilizationInfo> var1);

        public Builder quotas(QuotaUtilizationInfo ... var1);

        public Builder quotas(Consumer<QuotaUtilizationInfo.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);
    }
}

