/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a quota increase request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceQuotaIncreaseRequestInTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceQuotaIncreaseRequestInTemplate.Builder, ServiceQuotaIncreaseRequestInTemplate> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCode").getter(getter(ServiceQuotaIncreaseRequestInTemplate::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(ServiceQuotaIncreaseRequestInTemplate::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuotaCode").getter(getter(ServiceQuotaIncreaseRequestInTemplate::quotaCode))
            .setter(setter(Builder::quotaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()).build();

    private static final SdkField<String> QUOTA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuotaName").getter(getter(ServiceQuotaIncreaseRequestInTemplate::quotaName))
            .setter(setter(Builder::quotaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaName").build()).build();

    private static final SdkField<Double> DESIRED_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DesiredValue").getter(getter(ServiceQuotaIncreaseRequestInTemplate::desiredValue))
            .setter(setter(Builder::desiredValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredValue").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsRegion").getter(getter(ServiceQuotaIncreaseRequestInTemplate::awsRegion))
            .setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(ServiceQuotaIncreaseRequestInTemplate::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Boolean> GLOBAL_QUOTA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("GlobalQuota").getter(getter(ServiceQuotaIncreaseRequestInTemplate::globalQuota))
            .setter(setter(Builder::globalQuota))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalQuota").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            SERVICE_NAME_FIELD, QUOTA_CODE_FIELD, QUOTA_NAME_FIELD, DESIRED_VALUE_FIELD, AWS_REGION_FIELD, UNIT_FIELD,
            GLOBAL_QUOTA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceCode;

    private final String serviceName;

    private final String quotaCode;

    private final String quotaName;

    private final Double desiredValue;

    private final String awsRegion;

    private final String unit;

    private final Boolean globalQuota;

    private ServiceQuotaIncreaseRequestInTemplate(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.serviceName = builder.serviceName;
        this.quotaCode = builder.quotaCode;
        this.quotaName = builder.quotaName;
        this.desiredValue = builder.desiredValue;
        this.awsRegion = builder.awsRegion;
        this.unit = builder.unit;
        this.globalQuota = builder.globalQuota;
    }

    /**
     * <p>
     * The service identifier.
     * </p>
     * 
     * @return The service identifier.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The service name.
     * </p>
     * 
     * @return The service name.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The quota identifier.
     * </p>
     * 
     * @return The quota identifier.
     */
    public final String quotaCode() {
        return quotaCode;
    }

    /**
     * <p>
     * The quota name.
     * </p>
     * 
     * @return The quota name.
     */
    public final String quotaName() {
        return quotaName;
    }

    /**
     * <p>
     * The new, increased value of the quota.
     * </p>
     * 
     * @return The new, increased value of the quota.
     */
    public final Double desiredValue() {
        return desiredValue;
    }

    /**
     * <p>
     * The AWS Region.
     * </p>
     * 
     * @return The AWS Region.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The unit of measurement.
     * </p>
     * 
     * @return The unit of measurement.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * Indicates whether the quota is global.
     * </p>
     * 
     * @return Indicates whether the quota is global.
     */
    public final Boolean globalQuota() {
        return globalQuota;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(quotaName());
        hashCode = 31 * hashCode + Objects.hashCode(desiredValue());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(globalQuota());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceQuotaIncreaseRequestInTemplate)) {
            return false;
        }
        ServiceQuotaIncreaseRequestInTemplate other = (ServiceQuotaIncreaseRequestInTemplate) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(quotaCode(), other.quotaCode()) && Objects.equals(quotaName(), other.quotaName())
                && Objects.equals(desiredValue(), other.desiredValue()) && Objects.equals(awsRegion(), other.awsRegion())
                && Objects.equals(unit(), other.unit()) && Objects.equals(globalQuota(), other.globalQuota());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceQuotaIncreaseRequestInTemplate").add("ServiceCode", serviceCode())
                .add("ServiceName", serviceName()).add("QuotaCode", quotaCode()).add("QuotaName", quotaName())
                .add("DesiredValue", desiredValue()).add("AwsRegion", awsRegion()).add("Unit", unit())
                .add("GlobalQuota", globalQuota()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "QuotaCode":
            return Optional.ofNullable(clazz.cast(quotaCode()));
        case "QuotaName":
            return Optional.ofNullable(clazz.cast(quotaName()));
        case "DesiredValue":
            return Optional.ofNullable(clazz.cast(desiredValue()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "GlobalQuota":
            return Optional.ofNullable(clazz.cast(globalQuota()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceQuotaIncreaseRequestInTemplate, T> g) {
        return obj -> g.apply((ServiceQuotaIncreaseRequestInTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceQuotaIncreaseRequestInTemplate> {
        /**
         * <p>
         * The service identifier.
         * </p>
         * 
         * @param serviceCode
         *        The service identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The service name.
         * </p>
         * 
         * @param serviceName
         *        The service name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The quota identifier.
         * </p>
         * 
         * @param quotaCode
         *        The quota identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaCode(String quotaCode);

        /**
         * <p>
         * The quota name.
         * </p>
         * 
         * @param quotaName
         *        The quota name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaName(String quotaName);

        /**
         * <p>
         * The new, increased value of the quota.
         * </p>
         * 
         * @param desiredValue
         *        The new, increased value of the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredValue(Double desiredValue);

        /**
         * <p>
         * The AWS Region.
         * </p>
         * 
         * @param awsRegion
         *        The AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The unit of measurement.
         * </p>
         * 
         * @param unit
         *        The unit of measurement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * Indicates whether the quota is global.
         * </p>
         * 
         * @param globalQuota
         *        Indicates whether the quota is global.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalQuota(Boolean globalQuota);
    }

    static final class BuilderImpl implements Builder {
        private String serviceCode;

        private String serviceName;

        private String quotaCode;

        private String quotaName;

        private Double desiredValue;

        private String awsRegion;

        private String unit;

        private Boolean globalQuota;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceQuotaIncreaseRequestInTemplate model) {
            serviceCode(model.serviceCode);
            serviceName(model.serviceName);
            quotaCode(model.quotaCode);
            quotaName(model.quotaName);
            desiredValue(model.desiredValue);
            awsRegion(model.awsRegion);
            unit(model.unit);
            globalQuota(model.globalQuota);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        @Transient
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        @Transient
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getQuotaCode() {
            return quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        @Transient
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final String getQuotaName() {
            return quotaName;
        }

        public final void setQuotaName(String quotaName) {
            this.quotaName = quotaName;
        }

        @Override
        @Transient
        public final Builder quotaName(String quotaName) {
            this.quotaName = quotaName;
            return this;
        }

        public final Double getDesiredValue() {
            return desiredValue;
        }

        public final void setDesiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
        }

        @Override
        @Transient
        public final Builder desiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        @Transient
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        @Transient
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Boolean getGlobalQuota() {
            return globalQuota;
        }

        public final void setGlobalQuota(Boolean globalQuota) {
            this.globalQuota = globalQuota;
        }

        @Override
        @Transient
        public final Builder globalQuota(Boolean globalQuota) {
            this.globalQuota = globalQuota;
            return this;
        }

        @Override
        public ServiceQuotaIncreaseRequestInTemplate build() {
            return new ServiceQuotaIncreaseRequestInTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
