/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicediscovery.model.HealthStatus;
import software.amazon.awssdk.services.servicediscovery.model.InstanceHealthStatusMapCopier;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInstancesHealthStatusResponse
extends ServiceDiscoveryResponse
implements ToCopyableBuilder<Builder, GetInstancesHealthStatusResponse> {
    private static final SdkField<Map<String, String>> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Status").getter(GetInstancesHealthStatusResponse.getter(GetInstancesHealthStatusResponse::statusAsStrings)).setter(GetInstancesHealthStatusResponse.setter(Builder::statusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetInstancesHealthStatusResponse.getter(GetInstancesHealthStatusResponse::nextToken)).setter(GetInstancesHealthStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetInstancesHealthStatusResponse.memberNameToFieldInitializer();
    private final Map<String, String> status;
    private final String nextToken;

    private GetInstancesHealthStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
    }

    public final Map<String, HealthStatus> status() {
        return InstanceHealthStatusMapCopier.copyStringToEnum(this.status);
    }

    public final boolean hasStatus() {
        return this.status != null && !(this.status instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> statusAsStrings() {
        return this.status;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatus() ? this.statusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancesHealthStatusResponse)) {
            return false;
        }
        GetInstancesHealthStatusResponse other = (GetInstancesHealthStatusResponse)((Object)obj);
        return this.hasStatus() == other.hasStatus() && Objects.equals(this.statusAsStrings(), other.statusAsStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetInstancesHealthStatusResponse").add("Status", this.hasStatus() ? this.statusAsStrings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInstancesHealthStatusResponse, T> g) {
        return obj -> g.apply((GetInstancesHealthStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceDiscoveryResponse.BuilderImpl
    implements Builder {
        private Map<String, String> status = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancesHealthStatusResponse model) {
            super(model);
            this.statusWithStrings(model.status);
            this.nextToken(model.nextToken);
        }

        public final Map<String, String> getStatus() {
            if (this.status instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.status;
        }

        public final void setStatus(Map<String, String> status) {
            this.status = InstanceHealthStatusMapCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Map<String, String> status) {
            this.status = InstanceHealthStatusMapCopier.copy(status);
            return this;
        }

        @Override
        public final Builder status(Map<String, HealthStatus> status) {
            this.status = InstanceHealthStatusMapCopier.copyEnumToString(status);
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetInstancesHealthStatusResponse build() {
            return new GetInstancesHealthStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceDiscoveryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInstancesHealthStatusResponse> {
        public Builder statusWithStrings(Map<String, String> var1);

        public Builder status(Map<String, HealthStatus> var1);

        public Builder nextToken(String var1);
    }
}

