/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicediscovery.model.PrivateDnsNamespaceProperties;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryRequest;
import software.amazon.awssdk.services.servicediscovery.model.Tag;
import software.amazon.awssdk.services.servicediscovery.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePrivateDnsNamespaceRequest
extends ServiceDiscoveryRequest
implements ToCopyableBuilder<Builder, CreatePrivateDnsNamespaceRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreatePrivateDnsNamespaceRequest.getter(CreatePrivateDnsNamespaceRequest::name)).setter(CreatePrivateDnsNamespaceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(CreatePrivateDnsNamespaceRequest.getter(CreatePrivateDnsNamespaceRequest::creatorRequestId)).setter(CreatePrivateDnsNamespaceRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreatePrivateDnsNamespaceRequest.getter(CreatePrivateDnsNamespaceRequest::description)).setter(CreatePrivateDnsNamespaceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Vpc").getter(CreatePrivateDnsNamespaceRequest.getter(CreatePrivateDnsNamespaceRequest::vpc)).setter(CreatePrivateDnsNamespaceRequest.setter(Builder::vpc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreatePrivateDnsNamespaceRequest.getter(CreatePrivateDnsNamespaceRequest::tags)).setter(CreatePrivateDnsNamespaceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PrivateDnsNamespaceProperties> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Properties").getter(CreatePrivateDnsNamespaceRequest.getter(CreatePrivateDnsNamespaceRequest::properties)).setter(CreatePrivateDnsNamespaceRequest.setter(Builder::properties)).constructor(PrivateDnsNamespaceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CREATOR_REQUEST_ID_FIELD, DESCRIPTION_FIELD, VPC_FIELD, TAGS_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePrivateDnsNamespaceRequest.memberNameToFieldInitializer();
    private final String name;
    private final String creatorRequestId;
    private final String description;
    private final String vpc;
    private final List<Tag> tags;
    private final PrivateDnsNamespaceProperties properties;

    private CreatePrivateDnsNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.creatorRequestId = builder.creatorRequestId;
        this.description = builder.description;
        this.vpc = builder.vpc;
        this.tags = builder.tags;
        this.properties = builder.properties;
    }

    public final String name() {
        return this.name;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String description() {
        return this.description;
    }

    public final String vpc() {
        return this.vpc;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final PrivateDnsNamespaceProperties properties() {
        return this.properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrivateDnsNamespaceRequest)) {
            return false;
        }
        CreatePrivateDnsNamespaceRequest other = (CreatePrivateDnsNamespaceRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.vpc(), other.vpc()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePrivateDnsNamespaceRequest").add("Name", (Object)this.name()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("Description", (Object)this.description()).add("Vpc", (Object)this.vpc()).add("Tags", this.hasTags() ? this.tags() : null).add("Properties", (Object)this.properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Vpc", VPC_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePrivateDnsNamespaceRequest, T> g) {
        return obj -> g.apply((CreatePrivateDnsNamespaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceDiscoveryRequest.BuilderImpl
    implements Builder {
        private String name;
        private String creatorRequestId;
        private String description;
        private String vpc;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private PrivateDnsNamespaceProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrivateDnsNamespaceRequest model) {
            super(model);
            this.name(model.name);
            this.creatorRequestId(model.creatorRequestId);
            this.description(model.description);
            this.vpc(model.vpc);
            this.tags(model.tags);
            this.properties(model.properties);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVpc() {
            return this.vpc;
        }

        public final void setVpc(String vpc) {
            this.vpc = vpc;
        }

        @Override
        public final Builder vpc(String vpc) {
            this.vpc = vpc;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final PrivateDnsNamespaceProperties.Builder getProperties() {
            return this.properties != null ? this.properties.toBuilder() : null;
        }

        public final void setProperties(PrivateDnsNamespaceProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(PrivateDnsNamespaceProperties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePrivateDnsNamespaceRequest build() {
            return new CreatePrivateDnsNamespaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePrivateDnsNamespaceRequest> {
        public Builder name(String var1);

        public Builder creatorRequestId(String var1);

        public Builder description(String var1);

        public Builder vpc(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder properties(PrivateDnsNamespaceProperties var1);

        default public Builder properties(Consumer<PrivateDnsNamespaceProperties.Builder> properties) {
            return this.properties((PrivateDnsNamespaceProperties)((PrivateDnsNamespaceProperties.Builder)PrivateDnsNamespaceProperties.builder().applyMutation(properties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

