/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAssociatedResourceFilterCopier;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourceItemStatus;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourceType;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceCatalogAppRegistryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssociatedResourceRequest
extends ServiceCatalogAppRegistryRequest
implements ToCopyableBuilder<Builder, GetAssociatedResourceRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("application").getter(GetAssociatedResourceRequest.getter(GetAssociatedResourceRequest::application)).setter(GetAssociatedResourceRequest.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(GetAssociatedResourceRequest.getter(GetAssociatedResourceRequest::resourceTypeAsString)).setter(GetAssociatedResourceRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(GetAssociatedResourceRequest.getter(GetAssociatedResourceRequest::resource)).setter(GetAssociatedResourceRequest.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetAssociatedResourceRequest.getter(GetAssociatedResourceRequest::nextToken)).setter(GetAssociatedResourceRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TAG_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceTagStatus").getter(GetAssociatedResourceRequest.getter(GetAssociatedResourceRequest::resourceTagStatusAsStrings)).setter(GetAssociatedResourceRequest.setter(Builder::resourceTagStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceTagStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetAssociatedResourceRequest.getter(GetAssociatedResourceRequest::maxResults)).setter(GetAssociatedResourceRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_FIELD, NEXT_TOKEN_FIELD, RESOURCE_TAG_STATUS_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAssociatedResourceRequest.memberNameToFieldInitializer();
    private final String application;
    private final String resourceType;
    private final String resource;
    private final String nextToken;
    private final List<String> resourceTagStatus;
    private final Integer maxResults;

    private GetAssociatedResourceRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.resourceType = builder.resourceType;
        this.resource = builder.resource;
        this.nextToken = builder.nextToken;
        this.resourceTagStatus = builder.resourceTagStatus;
        this.maxResults = builder.maxResults;
    }

    public final String application() {
        return this.application;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resource() {
        return this.resource;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final List<ResourceItemStatus> resourceTagStatus() {
        return GetAssociatedResourceFilterCopier.copyStringToEnum(this.resourceTagStatus);
    }

    public final boolean hasResourceTagStatus() {
        return this.resourceTagStatus != null && !(this.resourceTagStatus instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTagStatusAsStrings() {
        return this.resourceTagStatus;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTagStatus() ? this.resourceTagStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedResourceRequest)) {
            return false;
        }
        GetAssociatedResourceRequest other = (GetAssociatedResourceRequest)((Object)obj);
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasResourceTagStatus() == other.hasResourceTagStatus() && Objects.equals(this.resourceTagStatusAsStrings(), other.resourceTagStatusAsStrings()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssociatedResourceRequest").add("Application", (Object)this.application()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Resource", (Object)this.resource()).add("NextToken", (Object)this.nextToken()).add("ResourceTagStatus", this.hasResourceTagStatus() ? this.resourceTagStatusAsStrings() : null).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "resourceTagStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceTagStatusAsStrings()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("application", APPLICATION_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("resourceTagStatus", RESOURCE_TAG_STATUS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssociatedResourceRequest, T> g) {
        return obj -> g.apply((GetAssociatedResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogAppRegistryRequest.BuilderImpl
    implements Builder {
        private String application;
        private String resourceType;
        private String resource;
        private String nextToken;
        private List<String> resourceTagStatus = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociatedResourceRequest model) {
            super(model);
            this.application(model.application);
            this.resourceType(model.resourceType);
            this.resource(model.resource);
            this.nextToken(model.nextToken);
            this.resourceTagStatusWithStrings(model.resourceTagStatus);
            this.maxResults(model.maxResults);
        }

        public final String getApplication() {
            return this.application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getResourceTagStatus() {
            if (this.resourceTagStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTagStatus;
        }

        public final void setResourceTagStatus(Collection<String> resourceTagStatus) {
            this.resourceTagStatus = GetAssociatedResourceFilterCopier.copy(resourceTagStatus);
        }

        @Override
        public final Builder resourceTagStatusWithStrings(Collection<String> resourceTagStatus) {
            this.resourceTagStatus = GetAssociatedResourceFilterCopier.copy(resourceTagStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagStatusWithStrings(String ... resourceTagStatus) {
            this.resourceTagStatusWithStrings(Arrays.asList(resourceTagStatus));
            return this;
        }

        @Override
        public final Builder resourceTagStatus(Collection<ResourceItemStatus> resourceTagStatus) {
            this.resourceTagStatus = GetAssociatedResourceFilterCopier.copyEnumToString(resourceTagStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagStatus(ResourceItemStatus ... resourceTagStatus) {
            this.resourceTagStatus(Arrays.asList(resourceTagStatus));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAssociatedResourceRequest build() {
            return new GetAssociatedResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceCatalogAppRegistryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssociatedResourceRequest> {
        public Builder application(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resource(String var1);

        public Builder nextToken(String var1);

        public Builder resourceTagStatusWithStrings(Collection<String> var1);

        public Builder resourceTagStatusWithStrings(String ... var1);

        public Builder resourceTagStatus(Collection<ResourceItemStatus> var1);

        public Builder resourceTagStatus(ResourceItemStatus ... var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

