/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.ServiceCatalogAppRegistryClient;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse;

public class ListAssociatedAttributeGroupsIterable
implements SdkIterable<ListAssociatedAttributeGroupsResponse> {
    private final ServiceCatalogAppRegistryClient client;
    private final ListAssociatedAttributeGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssociatedAttributeGroupsIterable(ServiceCatalogAppRegistryClient client, ListAssociatedAttributeGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAssociatedAttributeGroupsResponseFetcher();
    }

    public Iterator<ListAssociatedAttributeGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> attributeGroups() {
        Function<ListAssociatedAttributeGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.attributeGroups() != null) {
                return response.attributeGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssociatedAttributeGroupsResponseFetcher
    implements SyncPageFetcher<ListAssociatedAttributeGroupsResponse> {
        private ListAssociatedAttributeGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociatedAttributeGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssociatedAttributeGroupsResponse nextPage(ListAssociatedAttributeGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociatedAttributeGroupsIterable.this.client.listAssociatedAttributeGroups(ListAssociatedAttributeGroupsIterable.this.firstRequest);
            }
            return ListAssociatedAttributeGroupsIterable.this.client.listAssociatedAttributeGroups((ListAssociatedAttributeGroupsRequest)((Object)ListAssociatedAttributeGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

