/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.ShareStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePortfolioShareResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, UpdatePortfolioShareResponse> {
    private static final SdkField<String> PORTFOLIO_SHARE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortfolioShareToken").getter(UpdatePortfolioShareResponse.getter(UpdatePortfolioShareResponse::portfolioShareToken)).setter(UpdatePortfolioShareResponse.setter(Builder::portfolioShareToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioShareToken").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdatePortfolioShareResponse.getter(UpdatePortfolioShareResponse::statusAsString)).setter(UpdatePortfolioShareResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_SHARE_TOKEN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePortfolioShareResponse.memberNameToFieldInitializer();
    private final String portfolioShareToken;
    private final String status;

    private UpdatePortfolioShareResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioShareToken = builder.portfolioShareToken;
        this.status = builder.status;
    }

    public final String portfolioShareToken() {
        return this.portfolioShareToken;
    }

    public final ShareStatus status() {
        return ShareStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioShareToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePortfolioShareResponse)) {
            return false;
        }
        UpdatePortfolioShareResponse other = (UpdatePortfolioShareResponse)((Object)obj);
        return Objects.equals(this.portfolioShareToken(), other.portfolioShareToken()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePortfolioShareResponse").add("PortfolioShareToken", (Object)this.portfolioShareToken()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PortfolioShareToken": {
                return Optional.ofNullable(clazz.cast(this.portfolioShareToken()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("PortfolioShareToken", PORTFOLIO_SHARE_TOKEN_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePortfolioShareResponse, T> g) {
        return obj -> g.apply((UpdatePortfolioShareResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private String portfolioShareToken;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePortfolioShareResponse model) {
            super(model);
            this.portfolioShareToken(model.portfolioShareToken);
            this.status(model.status);
        }

        public final String getPortfolioShareToken() {
            return this.portfolioShareToken;
        }

        public final void setPortfolioShareToken(String portfolioShareToken) {
            this.portfolioShareToken = portfolioShareToken;
        }

        @Override
        public final Builder portfolioShareToken(String portfolioShareToken) {
            this.portfolioShareToken = portfolioShareToken;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public UpdatePortfolioShareResponse build() {
            return new UpdatePortfolioShareResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePortfolioShareResponse> {
        public Builder portfolioShareToken(String var1);

        public Builder status(String var1);

        public Builder status(ShareStatus var1);
    }
}

