/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProductViewFilterBy {
    FULL_TEXT_SEARCH("FullTextSearch"),
    OWNER("Owner"),
    PRODUCT_TYPE("ProductType"),
    SOURCE_PRODUCT_ID("SourceProductId"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProductViewFilterBy> VALUE_MAP;
    private final String value;

    private ProductViewFilterBy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProductViewFilterBy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProductViewFilterBy> knownValues() {
        EnumSet<ProductViewFilterBy> knownValues = EnumSet.allOf(ProductViewFilterBy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProductViewFilterBy.class, ProductViewFilterBy::toString);
    }
}

