/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.OrganizationNode;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletePortfolioShareRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, DeletePortfolioShareRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(DeletePortfolioShareRequest.getter(DeletePortfolioShareRequest::acceptLanguage)).setter(DeletePortfolioShareRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortfolioId").getter(DeletePortfolioShareRequest.getter(DeletePortfolioShareRequest::portfolioId)).setter(DeletePortfolioShareRequest.setter(Builder::portfolioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(DeletePortfolioShareRequest.getter(DeletePortfolioShareRequest::accountId)).setter(DeletePortfolioShareRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<OrganizationNode> ORGANIZATION_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationNode").getter(DeletePortfolioShareRequest.getter(DeletePortfolioShareRequest::organizationNode)).setter(DeletePortfolioShareRequest.setter(Builder::organizationNode)).constructor(OrganizationNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationNode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PORTFOLIO_ID_FIELD, ACCOUNT_ID_FIELD, ORGANIZATION_NODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeletePortfolioShareRequest.memberNameToFieldInitializer();
    private final String acceptLanguage;
    private final String portfolioId;
    private final String accountId;
    private final OrganizationNode organizationNode;

    private DeletePortfolioShareRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.accountId = builder.accountId;
        this.organizationNode = builder.organizationNode;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final String portfolioId() {
        return this.portfolioId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final OrganizationNode organizationNode() {
        return this.organizationNode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationNode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePortfolioShareRequest)) {
            return false;
        }
        DeletePortfolioShareRequest other = (DeletePortfolioShareRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.portfolioId(), other.portfolioId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.organizationNode(), other.organizationNode());
    }

    public final String toString() {
        return ToString.builder((String)"DeletePortfolioShareRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("PortfolioId", (Object)this.portfolioId()).add("AccountId", (Object)this.accountId()).add("OrganizationNode", (Object)this.organizationNode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "PortfolioId": {
                return Optional.ofNullable(clazz.cast(this.portfolioId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "OrganizationNode": {
                return Optional.ofNullable(clazz.cast(this.organizationNode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
        map.put("PortfolioId", PORTFOLIO_ID_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("OrganizationNode", ORGANIZATION_NODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletePortfolioShareRequest, T> g) {
        return obj -> g.apply((DeletePortfolioShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String portfolioId;
        private String accountId;
        private OrganizationNode organizationNode;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePortfolioShareRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.portfolioId(model.portfolioId);
            this.accountId(model.accountId);
            this.organizationNode(model.organizationNode);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final OrganizationNode.Builder getOrganizationNode() {
            return this.organizationNode != null ? this.organizationNode.toBuilder() : null;
        }

        public final void setOrganizationNode(OrganizationNode.BuilderImpl organizationNode) {
            this.organizationNode = organizationNode != null ? organizationNode.build() : null;
        }

        @Override
        public final Builder organizationNode(OrganizationNode organizationNode) {
            this.organizationNode = organizationNode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePortfolioShareRequest build() {
            return new DeletePortfolioShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeletePortfolioShareRequest> {
        public Builder acceptLanguage(String var1);

        public Builder portfolioId(String var1);

        public Builder accountId(String var1);

        public Builder organizationNode(OrganizationNode var1);

        default public Builder organizationNode(Consumer<OrganizationNode.Builder> organizationNode) {
            return this.organizationNode((OrganizationNode)((OrganizationNode.Builder)OrganizationNode.builder().applyMutation(organizationNode)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

