/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProvisionedProductStatus {
    AVAILABLE("AVAILABLE"),
    UNDER_CHANGE("UNDER_CHANGE"),
    TAINTED("TAINTED"),
    ERROR("ERROR"),
    PLAN_IN_PROGRESS("PLAN_IN_PROGRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProvisionedProductStatus> VALUE_MAP;
    private final String value;

    private ProvisionedProductStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProvisionedProductStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProvisionedProductStatus> knownValues() {
        EnumSet<ProvisionedProductStatus> knownValues = EnumSet.allOf(ProvisionedProductStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProvisionedProductStatus.class, ProvisionedProductStatus::toString);
    }
}

