/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.DataLakeEncryptionConfiguration;
import software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleConfiguration;
import software.amazon.awssdk.services.securitylake.model.DataLakeReplicationConfiguration;
import software.amazon.awssdk.services.securitylake.model.DataLakeStatus;
import software.amazon.awssdk.services.securitylake.model.DataLakeUpdateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLakeResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLakeResource> {
    private static final SdkField<String> CREATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createStatus").getter(DataLakeResource.getter(DataLakeResource::createStatusAsString)).setter(DataLakeResource.setter(Builder::createStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createStatus").build()}).build();
    private static final SdkField<String> DATA_LAKE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataLakeArn").getter(DataLakeResource.getter(DataLakeResource::dataLakeArn)).setter(DataLakeResource.setter(Builder::dataLakeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLakeArn").build()}).build();
    private static final SdkField<DataLakeEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(DataLakeResource.getter(DataLakeResource::encryptionConfiguration)).setter(DataLakeResource.setter(Builder::encryptionConfiguration)).constructor(DataLakeEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<DataLakeLifecycleConfiguration> LIFECYCLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lifecycleConfiguration").getter(DataLakeResource.getter(DataLakeResource::lifecycleConfiguration)).setter(DataLakeResource.setter(Builder::lifecycleConfiguration)).constructor(DataLakeLifecycleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleConfiguration").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(DataLakeResource.getter(DataLakeResource::region)).setter(DataLakeResource.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<DataLakeReplicationConfiguration> REPLICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("replicationConfiguration").getter(DataLakeResource.getter(DataLakeResource::replicationConfiguration)).setter(DataLakeResource.setter(Builder::replicationConfiguration)).constructor(DataLakeReplicationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationConfiguration").build()}).build();
    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketArn").getter(DataLakeResource.getter(DataLakeResource::s3BucketArn)).setter(DataLakeResource.setter(Builder::s3BucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketArn").build()}).build();
    private static final SdkField<DataLakeUpdateStatus> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("updateStatus").getter(DataLakeResource.getter(DataLakeResource::updateStatus)).setter(DataLakeResource.setter(Builder::updateStatus)).constructor(DataLakeUpdateStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_STATUS_FIELD, DATA_LAKE_ARN_FIELD, ENCRYPTION_CONFIGURATION_FIELD, LIFECYCLE_CONFIGURATION_FIELD, REGION_FIELD, REPLICATION_CONFIGURATION_FIELD, S3_BUCKET_ARN_FIELD, UPDATE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataLakeResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String createStatus;
    private final String dataLakeArn;
    private final DataLakeEncryptionConfiguration encryptionConfiguration;
    private final DataLakeLifecycleConfiguration lifecycleConfiguration;
    private final String region;
    private final DataLakeReplicationConfiguration replicationConfiguration;
    private final String s3BucketArn;
    private final DataLakeUpdateStatus updateStatus;

    private DataLakeResource(BuilderImpl builder) {
        this.createStatus = builder.createStatus;
        this.dataLakeArn = builder.dataLakeArn;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.lifecycleConfiguration = builder.lifecycleConfiguration;
        this.region = builder.region;
        this.replicationConfiguration = builder.replicationConfiguration;
        this.s3BucketArn = builder.s3BucketArn;
        this.updateStatus = builder.updateStatus;
    }

    public final DataLakeStatus createStatus() {
        return DataLakeStatus.fromValue(this.createStatus);
    }

    public final String createStatusAsString() {
        return this.createStatus;
    }

    public final String dataLakeArn() {
        return this.dataLakeArn;
    }

    public final DataLakeEncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final DataLakeLifecycleConfiguration lifecycleConfiguration() {
        return this.lifecycleConfiguration;
    }

    public final String region() {
        return this.region;
    }

    public final DataLakeReplicationConfiguration replicationConfiguration() {
        return this.replicationConfiguration;
    }

    public final String s3BucketArn() {
        return this.s3BucketArn;
    }

    public final DataLakeUpdateStatus updateStatus() {
        return this.updateStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLakeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeResource)) {
            return false;
        }
        DataLakeResource other = (DataLakeResource)obj;
        return Objects.equals(this.createStatusAsString(), other.createStatusAsString()) && Objects.equals(this.dataLakeArn(), other.dataLakeArn()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.lifecycleConfiguration(), other.lifecycleConfiguration()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.replicationConfiguration(), other.replicationConfiguration()) && Objects.equals(this.s3BucketArn(), other.s3BucketArn()) && Objects.equals(this.updateStatus(), other.updateStatus());
    }

    public final String toString() {
        return ToString.builder((String)"DataLakeResource").add("CreateStatus", (Object)this.createStatusAsString()).add("DataLakeArn", (Object)this.dataLakeArn()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("LifecycleConfiguration", (Object)this.lifecycleConfiguration()).add("Region", (Object)this.region()).add("ReplicationConfiguration", (Object)this.replicationConfiguration()).add("S3BucketArn", (Object)this.s3BucketArn()).add("UpdateStatus", (Object)this.updateStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createStatus": {
                return Optional.ofNullable(clazz.cast(this.createStatusAsString()));
            }
            case "dataLakeArn": {
                return Optional.ofNullable(clazz.cast(this.dataLakeArn()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "lifecycleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lifecycleConfiguration()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "replicationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.replicationConfiguration()));
            }
            case "s3BucketArn": {
                return Optional.ofNullable(clazz.cast(this.s3BucketArn()));
            }
            case "updateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createStatus", CREATE_STATUS_FIELD);
        map.put("dataLakeArn", DATA_LAKE_ARN_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("lifecycleConfiguration", LIFECYCLE_CONFIGURATION_FIELD);
        map.put("region", REGION_FIELD);
        map.put("replicationConfiguration", REPLICATION_CONFIGURATION_FIELD);
        map.put("s3BucketArn", S3_BUCKET_ARN_FIELD);
        map.put("updateStatus", UPDATE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeResource, T> g) {
        return obj -> g.apply((DataLakeResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String createStatus;
        private String dataLakeArn;
        private DataLakeEncryptionConfiguration encryptionConfiguration;
        private DataLakeLifecycleConfiguration lifecycleConfiguration;
        private String region;
        private DataLakeReplicationConfiguration replicationConfiguration;
        private String s3BucketArn;
        private DataLakeUpdateStatus updateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeResource model) {
            this.createStatus(model.createStatus);
            this.dataLakeArn(model.dataLakeArn);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.lifecycleConfiguration(model.lifecycleConfiguration);
            this.region(model.region);
            this.replicationConfiguration(model.replicationConfiguration);
            this.s3BucketArn(model.s3BucketArn);
            this.updateStatus(model.updateStatus);
        }

        public final String getCreateStatus() {
            return this.createStatus;
        }

        public final void setCreateStatus(String createStatus) {
            this.createStatus = createStatus;
        }

        @Override
        public final Builder createStatus(String createStatus) {
            this.createStatus = createStatus;
            return this;
        }

        @Override
        public final Builder createStatus(DataLakeStatus createStatus) {
            this.createStatus(createStatus == null ? null : createStatus.toString());
            return this;
        }

        public final String getDataLakeArn() {
            return this.dataLakeArn;
        }

        public final void setDataLakeArn(String dataLakeArn) {
            this.dataLakeArn = dataLakeArn;
        }

        @Override
        public final Builder dataLakeArn(String dataLakeArn) {
            this.dataLakeArn = dataLakeArn;
            return this;
        }

        public final DataLakeEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(DataLakeEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(DataLakeEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final DataLakeLifecycleConfiguration.Builder getLifecycleConfiguration() {
            return this.lifecycleConfiguration != null ? this.lifecycleConfiguration.toBuilder() : null;
        }

        public final void setLifecycleConfiguration(DataLakeLifecycleConfiguration.BuilderImpl lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration != null ? lifecycleConfiguration.build() : null;
        }

        @Override
        public final Builder lifecycleConfiguration(DataLakeLifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final DataLakeReplicationConfiguration.Builder getReplicationConfiguration() {
            return this.replicationConfiguration != null ? this.replicationConfiguration.toBuilder() : null;
        }

        public final void setReplicationConfiguration(DataLakeReplicationConfiguration.BuilderImpl replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration != null ? replicationConfiguration.build() : null;
        }

        @Override
        public final Builder replicationConfiguration(DataLakeReplicationConfiguration replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        public final String getS3BucketArn() {
            return this.s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final DataLakeUpdateStatus.Builder getUpdateStatus() {
            return this.updateStatus != null ? this.updateStatus.toBuilder() : null;
        }

        public final void setUpdateStatus(DataLakeUpdateStatus.BuilderImpl updateStatus) {
            this.updateStatus = updateStatus != null ? updateStatus.build() : null;
        }

        @Override
        public final Builder updateStatus(DataLakeUpdateStatus updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        public DataLakeResource build() {
            return new DataLakeResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLakeResource> {
        public Builder createStatus(String var1);

        public Builder createStatus(DataLakeStatus var1);

        public Builder dataLakeArn(String var1);

        public Builder encryptionConfiguration(DataLakeEncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<DataLakeEncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((DataLakeEncryptionConfiguration)((DataLakeEncryptionConfiguration.Builder)DataLakeEncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder lifecycleConfiguration(DataLakeLifecycleConfiguration var1);

        default public Builder lifecycleConfiguration(Consumer<DataLakeLifecycleConfiguration.Builder> lifecycleConfiguration) {
            return this.lifecycleConfiguration((DataLakeLifecycleConfiguration)((DataLakeLifecycleConfiguration.Builder)DataLakeLifecycleConfiguration.builder().applyMutation(lifecycleConfiguration)).build());
        }

        public Builder region(String var1);

        public Builder replicationConfiguration(DataLakeReplicationConfiguration var1);

        default public Builder replicationConfiguration(Consumer<DataLakeReplicationConfiguration.Builder> replicationConfiguration) {
            return this.replicationConfiguration((DataLakeReplicationConfiguration)((DataLakeReplicationConfiguration.Builder)DataLakeReplicationConfiguration.builder().applyMutation(replicationConfiguration)).build());
        }

        public Builder s3BucketArn(String var1);

        public Builder updateStatus(DataLakeUpdateStatus var1);

        default public Builder updateStatus(Consumer<DataLakeUpdateStatus.Builder> updateStatus) {
            return this.updateStatus((DataLakeUpdateStatus)((DataLakeUpdateStatus.Builder)DataLakeUpdateStatus.builder().applyMutation(updateStatus)).build());
        }
    }
}

