/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.AccessType;
import software.amazon.awssdk.services.securitylake.model.AccessTypeListCopier;
import software.amazon.awssdk.services.securitylake.model.AwsIdentity;
import software.amazon.awssdk.services.securitylake.model.LogSourceResource;
import software.amazon.awssdk.services.securitylake.model.LogSourceResourceListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.services.securitylake.model.Tag;
import software.amazon.awssdk.services.securitylake.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSubscriberRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, CreateSubscriberRequest> {
    private static final SdkField<List<String>> ACCESS_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessTypes").getter(CreateSubscriberRequest.getter(CreateSubscriberRequest::accessTypesAsStrings)).setter(CreateSubscriberRequest.setter(Builder::accessTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LogSourceResource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(CreateSubscriberRequest.getter(CreateSubscriberRequest::sources)).setter(CreateSubscriberRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogSourceResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBSCRIBER_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberDescription").getter(CreateSubscriberRequest.getter(CreateSubscriberRequest::subscriberDescription)).setter(CreateSubscriberRequest.setter(Builder::subscriberDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberDescription").build()}).build();
    private static final SdkField<AwsIdentity> SUBSCRIBER_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("subscriberIdentity").getter(CreateSubscriberRequest.getter(CreateSubscriberRequest::subscriberIdentity)).setter(CreateSubscriberRequest.setter(Builder::subscriberIdentity)).constructor(AwsIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberIdentity").build()}).build();
    private static final SdkField<String> SUBSCRIBER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriberName").getter(CreateSubscriberRequest.getter(CreateSubscriberRequest::subscriberName)).setter(CreateSubscriberRequest.setter(Builder::subscriberName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateSubscriberRequest.getter(CreateSubscriberRequest::tags)).setter(CreateSubscriberRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPES_FIELD, SOURCES_FIELD, SUBSCRIBER_DESCRIPTION_FIELD, SUBSCRIBER_IDENTITY_FIELD, SUBSCRIBER_NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSubscriberRequest.memberNameToFieldInitializer();
    private final List<String> accessTypes;
    private final List<LogSourceResource> sources;
    private final String subscriberDescription;
    private final AwsIdentity subscriberIdentity;
    private final String subscriberName;
    private final List<Tag> tags;

    private CreateSubscriberRequest(BuilderImpl builder) {
        super(builder);
        this.accessTypes = builder.accessTypes;
        this.sources = builder.sources;
        this.subscriberDescription = builder.subscriberDescription;
        this.subscriberIdentity = builder.subscriberIdentity;
        this.subscriberName = builder.subscriberName;
        this.tags = builder.tags;
    }

    public final List<AccessType> accessTypes() {
        return AccessTypeListCopier.copyStringToEnum(this.accessTypes);
    }

    public final boolean hasAccessTypes() {
        return this.accessTypes != null && !(this.accessTypes instanceof SdkAutoConstructList);
    }

    public final List<String> accessTypesAsStrings() {
        return this.accessTypes;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<LogSourceResource> sources() {
        return this.sources;
    }

    public final String subscriberDescription() {
        return this.subscriberDescription;
    }

    public final AwsIdentity subscriberIdentity() {
        return this.subscriberIdentity;
    }

    public final String subscriberName() {
        return this.subscriberName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessTypes() ? this.accessTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriberName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriberRequest)) {
            return false;
        }
        CreateSubscriberRequest other = (CreateSubscriberRequest)((Object)obj);
        return this.hasAccessTypes() == other.hasAccessTypes() && Objects.equals(this.accessTypesAsStrings(), other.accessTypesAsStrings()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.subscriberDescription(), other.subscriberDescription()) && Objects.equals(this.subscriberIdentity(), other.subscriberIdentity()) && Objects.equals(this.subscriberName(), other.subscriberName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSubscriberRequest").add("AccessTypes", this.hasAccessTypes() ? this.accessTypesAsStrings() : null).add("Sources", this.hasSources() ? this.sources() : null).add("SubscriberDescription", (Object)this.subscriberDescription()).add("SubscriberIdentity", (Object)this.subscriberIdentity()).add("SubscriberName", (Object)this.subscriberName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessTypes": {
                return Optional.ofNullable(clazz.cast(this.accessTypesAsStrings()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "subscriberDescription": {
                return Optional.ofNullable(clazz.cast(this.subscriberDescription()));
            }
            case "subscriberIdentity": {
                return Optional.ofNullable(clazz.cast(this.subscriberIdentity()));
            }
            case "subscriberName": {
                return Optional.ofNullable(clazz.cast(this.subscriberName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accessTypes", ACCESS_TYPES_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("subscriberDescription", SUBSCRIBER_DESCRIPTION_FIELD);
        map.put("subscriberIdentity", SUBSCRIBER_IDENTITY_FIELD);
        map.put("subscriberName", SUBSCRIBER_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriberRequest, T> g) {
        return obj -> g.apply((CreateSubscriberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private List<String> accessTypes = DefaultSdkAutoConstructList.getInstance();
        private List<LogSourceResource> sources = DefaultSdkAutoConstructList.getInstance();
        private String subscriberDescription;
        private AwsIdentity subscriberIdentity;
        private String subscriberName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriberRequest model) {
            super(model);
            this.accessTypesWithStrings(model.accessTypes);
            this.sources(model.sources);
            this.subscriberDescription(model.subscriberDescription);
            this.subscriberIdentity(model.subscriberIdentity);
            this.subscriberName(model.subscriberName);
            this.tags(model.tags);
        }

        public final Collection<String> getAccessTypes() {
            if (this.accessTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accessTypes;
        }

        public final void setAccessTypes(Collection<String> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copy(accessTypes);
        }

        @Override
        public final Builder accessTypesWithStrings(Collection<String> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copy(accessTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTypesWithStrings(String ... accessTypes) {
            this.accessTypesWithStrings(Arrays.asList(accessTypes));
            return this;
        }

        @Override
        public final Builder accessTypes(Collection<AccessType> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copyEnumToString(accessTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTypes(AccessType ... accessTypes) {
            this.accessTypes(Arrays.asList(accessTypes));
            return this;
        }

        public final List<LogSourceResource.Builder> getSources() {
            List<LogSourceResource.Builder> result = LogSourceResourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<LogSourceResource.BuilderImpl> sources) {
            this.sources = LogSourceResourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<LogSourceResource> sources) {
            this.sources = LogSourceResourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(LogSourceResource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<LogSourceResource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (LogSourceResource)((LogSourceResource.Builder)LogSourceResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubscriberDescription() {
            return this.subscriberDescription;
        }

        public final void setSubscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
        }

        @Override
        public final Builder subscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
            return this;
        }

        public final AwsIdentity.Builder getSubscriberIdentity() {
            return this.subscriberIdentity != null ? this.subscriberIdentity.toBuilder() : null;
        }

        public final void setSubscriberIdentity(AwsIdentity.BuilderImpl subscriberIdentity) {
            this.subscriberIdentity = subscriberIdentity != null ? subscriberIdentity.build() : null;
        }

        @Override
        public final Builder subscriberIdentity(AwsIdentity subscriberIdentity) {
            this.subscriberIdentity = subscriberIdentity;
            return this;
        }

        public final String getSubscriberName() {
            return this.subscriberName;
        }

        public final void setSubscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
        }

        @Override
        public final Builder subscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriberRequest build() {
            return new CreateSubscriberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSubscriberRequest> {
        public Builder accessTypesWithStrings(Collection<String> var1);

        public Builder accessTypesWithStrings(String ... var1);

        public Builder accessTypes(Collection<AccessType> var1);

        public Builder accessTypes(AccessType ... var1);

        public Builder sources(Collection<LogSourceResource> var1);

        public Builder sources(LogSourceResource ... var1);

        public Builder sources(Consumer<LogSourceResource.Builder> ... var1);

        public Builder subscriberDescription(String var1);

        public Builder subscriberIdentity(AwsIdentity var1);

        default public Builder subscriberIdentity(Consumer<AwsIdentity.Builder> subscriberIdentity) {
            return this.subscriberIdentity((AwsIdentity)((AwsIdentity.Builder)AwsIdentity.builder().applyMutation(subscriberIdentity)).build());
        }

        public Builder subscriberName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

