/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLakeException
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLakeException> {
    private static final SdkField<String> EXCEPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exception").getter(DataLakeException.getter(DataLakeException::exception)).setter(DataLakeException.setter(Builder::exception)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exception").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(DataLakeException.getter(DataLakeException::region)).setter(DataLakeException.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> REMEDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remediation").getter(DataLakeException.getter(DataLakeException::remediation)).setter(DataLakeException.setter(Builder::remediation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(DataLakeException.getter(DataLakeException::timestamp)).setter(DataLakeException.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPTION_FIELD, REGION_FIELD, REMEDIATION_FIELD, TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataLakeException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String exception;
    private final String region;
    private final String remediation;
    private final Instant timestamp;

    private DataLakeException(BuilderImpl builder) {
        this.exception = builder.exception;
        this.region = builder.region;
        this.remediation = builder.remediation;
        this.timestamp = builder.timestamp;
    }

    public final String exception() {
        return this.exception;
    }

    public final String region() {
        return this.region;
    }

    public final String remediation() {
        return this.remediation;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exception());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediation());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeException)) {
            return false;
        }
        DataLakeException other = (DataLakeException)obj;
        return Objects.equals(this.exception(), other.exception()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.remediation(), other.remediation()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"DataLakeException").add("Exception", (Object)this.exception()).add("Region", (Object)this.region()).add("Remediation", (Object)this.remediation()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exception": {
                return Optional.ofNullable(clazz.cast(this.exception()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "remediation": {
                return Optional.ofNullable(clazz.cast(this.remediation()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exception", EXCEPTION_FIELD);
        map.put("region", REGION_FIELD);
        map.put("remediation", REMEDIATION_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeException, T> g) {
        return obj -> g.apply((DataLakeException)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exception;
        private String region;
        private String remediation;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeException model) {
            this.exception(model.exception);
            this.region(model.region);
            this.remediation(model.remediation);
            this.timestamp(model.timestamp);
        }

        public final String getException() {
            return this.exception;
        }

        public final void setException(String exception) {
            this.exception = exception;
        }

        @Override
        public final Builder exception(String exception) {
            this.exception = exception;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getRemediation() {
            return this.remediation;
        }

        public final void setRemediation(String remediation) {
            this.remediation = remediation;
        }

        @Override
        public final Builder remediation(String remediation) {
            this.remediation = remediation;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public DataLakeException build() {
            return new DataLakeException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLakeException> {
        public Builder exception(String var1);

        public Builder region(String var1);

        public Builder remediation(String var1);

        public Builder timestamp(Instant var1);
    }
}

