/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityir.model.SecurityIrRequest;
import software.amazon.awssdk.services.securityir.model.UsefulnessRating;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendFeedbackRequest
extends SecurityIrRequest
implements ToCopyableBuilder<Builder, SendFeedbackRequest> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseId").getter(SendFeedbackRequest.getter(SendFeedbackRequest::caseId)).setter(SendFeedbackRequest.setter(Builder::caseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("caseId").build()}).build();
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resultId").getter(SendFeedbackRequest.getter(SendFeedbackRequest::resultId)).setter(SendFeedbackRequest.setter(Builder::resultId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resultId").build()}).build();
    private static final SdkField<String> USEFULNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usefulness").getter(SendFeedbackRequest.getter(SendFeedbackRequest::usefulnessAsString)).setter(SendFeedbackRequest.setter(Builder::usefulness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usefulness").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(SendFeedbackRequest.getter(SendFeedbackRequest::comment)).setter(SendFeedbackRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, RESULT_ID_FIELD, USEFULNESS_FIELD, COMMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendFeedbackRequest.memberNameToFieldInitializer();
    private final String caseId;
    private final String resultId;
    private final String usefulness;
    private final String comment;

    private SendFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.resultId = builder.resultId;
        this.usefulness = builder.usefulness;
        this.comment = builder.comment;
    }

    public final String caseId() {
        return this.caseId;
    }

    public final String resultId() {
        return this.resultId;
    }

    public final UsefulnessRating usefulness() {
        return UsefulnessRating.fromValue(this.usefulness);
    }

    public final String usefulnessAsString() {
        return this.usefulness;
    }

    public final String comment() {
        return this.comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usefulnessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendFeedbackRequest)) {
            return false;
        }
        SendFeedbackRequest other = (SendFeedbackRequest)((Object)obj);
        return Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.resultId(), other.resultId()) && Objects.equals(this.usefulnessAsString(), other.usefulnessAsString()) && Objects.equals(this.comment(), other.comment());
    }

    public final String toString() {
        return ToString.builder((String)"SendFeedbackRequest").add("CaseId", (Object)this.caseId()).add("ResultId", (Object)this.resultId()).add("Usefulness", (Object)this.usefulnessAsString()).add("Comment", (Object)this.comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseId": {
                return Optional.ofNullable(clazz.cast(this.caseId()));
            }
            case "resultId": {
                return Optional.ofNullable(clazz.cast(this.resultId()));
            }
            case "usefulness": {
                return Optional.ofNullable(clazz.cast(this.usefulnessAsString()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("resultId", RESULT_ID_FIELD);
        map.put("usefulness", USEFULNESS_FIELD);
        map.put("comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendFeedbackRequest, T> g) {
        return obj -> g.apply((SendFeedbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrRequest.BuilderImpl
    implements Builder {
        private String caseId;
        private String resultId;
        private String usefulness;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(SendFeedbackRequest model) {
            super(model);
            this.caseId(model.caseId);
            this.resultId(model.resultId);
            this.usefulness(model.usefulness);
            this.comment(model.comment);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getResultId() {
            return this.resultId;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final String getUsefulness() {
            return this.usefulness;
        }

        public final void setUsefulness(String usefulness) {
            this.usefulness = usefulness;
        }

        @Override
        public final Builder usefulness(String usefulness) {
            this.usefulness = usefulness;
            return this;
        }

        @Override
        public final Builder usefulness(UsefulnessRating usefulness) {
            this.usefulness(usefulness == null ? null : usefulness.toString());
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendFeedbackRequest build() {
            return new SendFeedbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityIrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendFeedbackRequest> {
        public Builder caseId(String var1);

        public Builder resultId(String var1);

        public Builder usefulness(String var1);

        public Builder usefulness(UsefulnessRating var1);

        public Builder comment(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

