/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityir.model.OrganizationalUnitsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MembershipAccountsConfigurations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MembershipAccountsConfigurations> {
    private static final SdkField<Boolean> COVER_ENTIRE_ORGANIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("coverEntireOrganization").getter(MembershipAccountsConfigurations.getter(MembershipAccountsConfigurations::coverEntireOrganization)).setter(MembershipAccountsConfigurations.setter(Builder::coverEntireOrganization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coverEntireOrganization").build()}).build();
    private static final SdkField<List<String>> ORGANIZATIONAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("organizationalUnits").getter(MembershipAccountsConfigurations.getter(MembershipAccountsConfigurations::organizationalUnits)).setter(MembershipAccountsConfigurations.setter(Builder::organizationalUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COVER_ENTIRE_ORGANIZATION_FIELD, ORGANIZATIONAL_UNITS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MembershipAccountsConfigurations.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean coverEntireOrganization;
    private final List<String> organizationalUnits;

    private MembershipAccountsConfigurations(BuilderImpl builder) {
        this.coverEntireOrganization = builder.coverEntireOrganization;
        this.organizationalUnits = builder.organizationalUnits;
    }

    public final Boolean coverEntireOrganization() {
        return this.coverEntireOrganization;
    }

    public final boolean hasOrganizationalUnits() {
        return this.organizationalUnits != null && !(this.organizationalUnits instanceof SdkAutoConstructList);
    }

    public final List<String> organizationalUnits() {
        return this.organizationalUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coverEntireOrganization());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnits() ? this.organizationalUnits() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipAccountsConfigurations)) {
            return false;
        }
        MembershipAccountsConfigurations other = (MembershipAccountsConfigurations)obj;
        return Objects.equals(this.coverEntireOrganization(), other.coverEntireOrganization()) && this.hasOrganizationalUnits() == other.hasOrganizationalUnits() && Objects.equals(this.organizationalUnits(), other.organizationalUnits());
    }

    public final String toString() {
        return ToString.builder((String)"MembershipAccountsConfigurations").add("CoverEntireOrganization", (Object)this.coverEntireOrganization()).add("OrganizationalUnits", this.hasOrganizationalUnits() ? this.organizationalUnits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "coverEntireOrganization": {
                return Optional.ofNullable(clazz.cast(this.coverEntireOrganization()));
            }
            case "organizationalUnits": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("coverEntireOrganization", COVER_ENTIRE_ORGANIZATION_FIELD);
        map.put("organizationalUnits", ORGANIZATIONAL_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MembershipAccountsConfigurations, T> g) {
        return obj -> g.apply((MembershipAccountsConfigurations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean coverEntireOrganization;
        private List<String> organizationalUnits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MembershipAccountsConfigurations model) {
            this.coverEntireOrganization(model.coverEntireOrganization);
            this.organizationalUnits(model.organizationalUnits);
        }

        public final Boolean getCoverEntireOrganization() {
            return this.coverEntireOrganization;
        }

        public final void setCoverEntireOrganization(Boolean coverEntireOrganization) {
            this.coverEntireOrganization = coverEntireOrganization;
        }

        @Override
        public final Builder coverEntireOrganization(Boolean coverEntireOrganization) {
            this.coverEntireOrganization = coverEntireOrganization;
            return this;
        }

        public final Collection<String> getOrganizationalUnits() {
            if (this.organizationalUnits instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationalUnits;
        }

        public final void setOrganizationalUnits(Collection<String> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitsCopier.copy(organizationalUnits);
        }

        @Override
        public final Builder organizationalUnits(Collection<String> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitsCopier.copy(organizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(String ... organizationalUnits) {
            this.organizationalUnits(Arrays.asList(organizationalUnits));
            return this;
        }

        public MembershipAccountsConfigurations build() {
            return new MembershipAccountsConfigurations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MembershipAccountsConfigurations> {
        public Builder coverEntireOrganization(Boolean var1);

        public Builder organizationalUnits(Collection<String> var1);

        public Builder organizationalUnits(String ... var1);
    }
}

