/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityir.model.AwsRegion;
import software.amazon.awssdk.services.securityir.model.MembershipStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMembershipItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListMembershipItem> {
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipId").getter(ListMembershipItem.getter(ListMembershipItem::membershipId)).setter(ListMembershipItem.setter(Builder::membershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(ListMembershipItem.getter(ListMembershipItem::accountId)).setter(ListMembershipItem.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(ListMembershipItem.getter(ListMembershipItem::regionAsString)).setter(ListMembershipItem.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipArn").getter(ListMembershipItem.getter(ListMembershipItem::membershipArn)).setter(ListMembershipItem.setter(Builder::membershipArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()}).build();
    private static final SdkField<String> MEMBERSHIP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipStatus").getter(ListMembershipItem.getter(ListMembershipItem::membershipStatusAsString)).setter(ListMembershipItem.setter(Builder::membershipStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_ID_FIELD, ACCOUNT_ID_FIELD, REGION_FIELD, MEMBERSHIP_ARN_FIELD, MEMBERSHIP_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMembershipItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String membershipId;
    private final String accountId;
    private final String region;
    private final String membershipArn;
    private final String membershipStatus;

    private ListMembershipItem(BuilderImpl builder) {
        this.membershipId = builder.membershipId;
        this.accountId = builder.accountId;
        this.region = builder.region;
        this.membershipArn = builder.membershipArn;
        this.membershipStatus = builder.membershipStatus;
    }

    public final String membershipId() {
        return this.membershipId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final AwsRegion region() {
        return AwsRegion.fromValue(this.region);
    }

    public final String regionAsString() {
        return this.region;
    }

    public final String membershipArn() {
        return this.membershipArn;
    }

    public final MembershipStatus membershipStatus() {
        return MembershipStatus.fromValue(this.membershipStatus);
    }

    public final String membershipStatusAsString() {
        return this.membershipStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembershipItem)) {
            return false;
        }
        ListMembershipItem other = (ListMembershipItem)obj;
        return Objects.equals(this.membershipId(), other.membershipId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.regionAsString(), other.regionAsString()) && Objects.equals(this.membershipArn(), other.membershipArn()) && Objects.equals(this.membershipStatusAsString(), other.membershipStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListMembershipItem").add("MembershipId", (Object)this.membershipId()).add("AccountId", (Object)this.accountId()).add("Region", (Object)this.regionAsString()).add("MembershipArn", (Object)this.membershipArn()).add("MembershipStatus", (Object)this.membershipStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipId": {
                return Optional.ofNullable(clazz.cast(this.membershipId()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.regionAsString()));
            }
            case "membershipArn": {
                return Optional.ofNullable(clazz.cast(this.membershipArn()));
            }
            case "membershipStatus": {
                return Optional.ofNullable(clazz.cast(this.membershipStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("region", REGION_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("membershipStatus", MEMBERSHIP_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMembershipItem, T> g) {
        return obj -> g.apply((ListMembershipItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String membershipId;
        private String accountId;
        private String region;
        private String membershipArn;
        private String membershipStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembershipItem model) {
            this.membershipId(model.membershipId);
            this.accountId(model.accountId);
            this.region(model.region);
            this.membershipArn(model.membershipArn);
            this.membershipStatus(model.membershipStatus);
        }

        public final String getMembershipId() {
            return this.membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(AwsRegion region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final String getMembershipArn() {
            return this.membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getMembershipStatus() {
            return this.membershipStatus;
        }

        public final void setMembershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
        }

        @Override
        public final Builder membershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
            return this;
        }

        @Override
        public final Builder membershipStatus(MembershipStatus membershipStatus) {
            this.membershipStatus(membershipStatus == null ? null : membershipStatus.toString());
            return this;
        }

        public ListMembershipItem build() {
            return new ListMembershipItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListMembershipItem> {
        public Builder membershipId(String var1);

        public Builder accountId(String var1);

        public Builder region(String var1);

        public Builder region(AwsRegion var1);

        public Builder membershipArn(String var1);

        public Builder membershipStatus(String var1);

        public Builder membershipStatus(MembershipStatus var1);
    }
}

