/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityir.model.IncidentResponder;
import software.amazon.awssdk.services.securityir.model.IncidentResponseTeamCopier;
import software.amazon.awssdk.services.securityir.model.OptInFeature;
import software.amazon.awssdk.services.securityir.model.OptInFeaturesCopier;
import software.amazon.awssdk.services.securityir.model.SecurityIrRequest;
import software.amazon.awssdk.services.securityir.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMembershipRequest
extends SecurityIrRequest
implements ToCopyableBuilder<Builder, CreateMembershipRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateMembershipRequest.getter(CreateMembershipRequest::clientToken)).setter(CreateMembershipRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> MEMBERSHIP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipName").getter(CreateMembershipRequest.getter(CreateMembershipRequest::membershipName)).setter(CreateMembershipRequest.setter(Builder::membershipName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipName").build()}).build();
    private static final SdkField<List<IncidentResponder>> INCIDENT_RESPONSE_TEAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("incidentResponseTeam").getter(CreateMembershipRequest.getter(CreateMembershipRequest::incidentResponseTeam)).setter(CreateMembershipRequest.setter(Builder::incidentResponseTeam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentResponseTeam").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IncidentResponder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OptInFeature>> OPT_IN_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("optInFeatures").getter(CreateMembershipRequest.getter(CreateMembershipRequest::optInFeatures)).setter(CreateMembershipRequest.setter(Builder::optInFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optInFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptInFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateMembershipRequest.getter(CreateMembershipRequest::tags)).setter(CreateMembershipRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> COVER_ENTIRE_ORGANIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("coverEntireOrganization").getter(CreateMembershipRequest.getter(CreateMembershipRequest::coverEntireOrganization)).setter(CreateMembershipRequest.setter(Builder::coverEntireOrganization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coverEntireOrganization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, MEMBERSHIP_NAME_FIELD, INCIDENT_RESPONSE_TEAM_FIELD, OPT_IN_FEATURES_FIELD, TAGS_FIELD, COVER_ENTIRE_ORGANIZATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMembershipRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String membershipName;
    private final List<IncidentResponder> incidentResponseTeam;
    private final List<OptInFeature> optInFeatures;
    private final Map<String, String> tags;
    private final Boolean coverEntireOrganization;

    private CreateMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.membershipName = builder.membershipName;
        this.incidentResponseTeam = builder.incidentResponseTeam;
        this.optInFeatures = builder.optInFeatures;
        this.tags = builder.tags;
        this.coverEntireOrganization = builder.coverEntireOrganization;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String membershipName() {
        return this.membershipName;
    }

    public final boolean hasIncidentResponseTeam() {
        return this.incidentResponseTeam != null && !(this.incidentResponseTeam instanceof SdkAutoConstructList);
    }

    public final List<IncidentResponder> incidentResponseTeam() {
        return this.incidentResponseTeam;
    }

    public final boolean hasOptInFeatures() {
        return this.optInFeatures != null && !(this.optInFeatures instanceof SdkAutoConstructList);
    }

    public final List<OptInFeature> optInFeatures() {
        return this.optInFeatures;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Boolean coverEntireOrganization() {
        return this.coverEntireOrganization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncidentResponseTeam() ? this.incidentResponseTeam() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptInFeatures() ? this.optInFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.coverEntireOrganization());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembershipRequest)) {
            return false;
        }
        CreateMembershipRequest other = (CreateMembershipRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.membershipName(), other.membershipName()) && this.hasIncidentResponseTeam() == other.hasIncidentResponseTeam() && Objects.equals(this.incidentResponseTeam(), other.incidentResponseTeam()) && this.hasOptInFeatures() == other.hasOptInFeatures() && Objects.equals(this.optInFeatures(), other.optInFeatures()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.coverEntireOrganization(), other.coverEntireOrganization());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMembershipRequest").add("ClientToken", (Object)this.clientToken()).add("MembershipName", (Object)(this.membershipName() == null ? null : "*** Sensitive Data Redacted ***")).add("IncidentResponseTeam", this.hasIncidentResponseTeam() ? this.incidentResponseTeam() : null).add("OptInFeatures", this.hasOptInFeatures() ? this.optInFeatures() : null).add("Tags", this.hasTags() ? this.tags() : null).add("CoverEntireOrganization", (Object)this.coverEntireOrganization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "membershipName": {
                return Optional.ofNullable(clazz.cast(this.membershipName()));
            }
            case "incidentResponseTeam": {
                return Optional.ofNullable(clazz.cast(this.incidentResponseTeam()));
            }
            case "optInFeatures": {
                return Optional.ofNullable(clazz.cast(this.optInFeatures()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "coverEntireOrganization": {
                return Optional.ofNullable(clazz.cast(this.coverEntireOrganization()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("membershipName", MEMBERSHIP_NAME_FIELD);
        map.put("incidentResponseTeam", INCIDENT_RESPONSE_TEAM_FIELD);
        map.put("optInFeatures", OPT_IN_FEATURES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("coverEntireOrganization", COVER_ENTIRE_ORGANIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMembershipRequest, T> g) {
        return obj -> g.apply((CreateMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String membershipName;
        private List<IncidentResponder> incidentResponseTeam = DefaultSdkAutoConstructList.getInstance();
        private List<OptInFeature> optInFeatures = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean coverEntireOrganization;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembershipRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.membershipName(model.membershipName);
            this.incidentResponseTeam(model.incidentResponseTeam);
            this.optInFeatures(model.optInFeatures);
            this.tags(model.tags);
            this.coverEntireOrganization(model.coverEntireOrganization);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getMembershipName() {
            return this.membershipName;
        }

        public final void setMembershipName(String membershipName) {
            this.membershipName = membershipName;
        }

        @Override
        public final Builder membershipName(String membershipName) {
            this.membershipName = membershipName;
            return this;
        }

        public final List<IncidentResponder.Builder> getIncidentResponseTeam() {
            List<IncidentResponder.Builder> result = IncidentResponseTeamCopier.copyToBuilder(this.incidentResponseTeam);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncidentResponseTeam(Collection<IncidentResponder.BuilderImpl> incidentResponseTeam) {
            this.incidentResponseTeam = IncidentResponseTeamCopier.copyFromBuilder(incidentResponseTeam);
        }

        @Override
        public final Builder incidentResponseTeam(Collection<IncidentResponder> incidentResponseTeam) {
            this.incidentResponseTeam = IncidentResponseTeamCopier.copy(incidentResponseTeam);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentResponseTeam(IncidentResponder ... incidentResponseTeam) {
            this.incidentResponseTeam(Arrays.asList(incidentResponseTeam));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentResponseTeam(Consumer<IncidentResponder.Builder> ... incidentResponseTeam) {
            this.incidentResponseTeam(Stream.of(incidentResponseTeam).map(c -> (IncidentResponder)((IncidentResponder.Builder)IncidentResponder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OptInFeature.Builder> getOptInFeatures() {
            List<OptInFeature.Builder> result = OptInFeaturesCopier.copyToBuilder(this.optInFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptInFeatures(Collection<OptInFeature.BuilderImpl> optInFeatures) {
            this.optInFeatures = OptInFeaturesCopier.copyFromBuilder(optInFeatures);
        }

        @Override
        public final Builder optInFeatures(Collection<OptInFeature> optInFeatures) {
            this.optInFeatures = OptInFeaturesCopier.copy(optInFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optInFeatures(OptInFeature ... optInFeatures) {
            this.optInFeatures(Arrays.asList(optInFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optInFeatures(Consumer<OptInFeature.Builder> ... optInFeatures) {
            this.optInFeatures(Stream.of(optInFeatures).map(c -> (OptInFeature)((OptInFeature.Builder)OptInFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Boolean getCoverEntireOrganization() {
            return this.coverEntireOrganization;
        }

        public final void setCoverEntireOrganization(Boolean coverEntireOrganization) {
            this.coverEntireOrganization = coverEntireOrganization;
        }

        @Override
        public final Builder coverEntireOrganization(Boolean coverEntireOrganization) {
            this.coverEntireOrganization = coverEntireOrganization;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMembershipRequest build() {
            return new CreateMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityIrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMembershipRequest> {
        public Builder clientToken(String var1);

        public Builder membershipName(String var1);

        public Builder incidentResponseTeam(Collection<IncidentResponder> var1);

        public Builder incidentResponseTeam(IncidentResponder ... var1);

        public Builder incidentResponseTeam(Consumer<IncidentResponder.Builder> ... var1);

        public Builder optInFeatures(Collection<OptInFeature> var1);

        public Builder optInFeatures(OptInFeature ... var1);

        public Builder optInFeatures(Consumer<OptInFeature.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder coverEntireOrganization(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

