/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityir.model.ListCasesItem;
import software.amazon.awssdk.services.securityir.model.ListCasesItemsCopier;
import software.amazon.awssdk.services.securityir.model.SecurityIrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCasesResponse
extends SecurityIrResponse
implements ToCopyableBuilder<Builder, ListCasesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCasesResponse.getter(ListCasesResponse::nextToken)).setter(ListCasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ListCasesItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(ListCasesResponse.getter(ListCasesResponse::items)).setter(ListCasesResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListCasesItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("total").getter(ListCasesResponse.getter(ListCasesResponse::total)).setter(ListCasesResponse.setter(Builder::total)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ITEMS_FIELD, TOTAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCasesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ListCasesItem> items;
    private final Long total;

    private ListCasesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.items = builder.items;
        this.total = builder.total;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<ListCasesItem> items() {
        return this.items;
    }

    public final Long total() {
        return this.total;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCasesResponse)) {
            return false;
        }
        ListCasesResponse other = (ListCasesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.total(), other.total());
    }

    public final String toString() {
        return ToString.builder((String)"ListCasesResponse").add("NextToken", (Object)this.nextToken()).add("Items", this.hasItems() ? this.items() : null).add("Total", (Object)this.total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("items", ITEMS_FIELD);
        map.put("total", TOTAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCasesResponse, T> g) {
        return obj -> g.apply((ListCasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListCasesItem> items = DefaultSdkAutoConstructList.getInstance();
        private Long total;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCasesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.items(model.items);
            this.total(model.total);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListCasesItem.Builder> getItems() {
            List<ListCasesItem.Builder> result = ListCasesItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ListCasesItem.BuilderImpl> items) {
            this.items = ListCasesItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ListCasesItem> items) {
            this.items = ListCasesItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ListCasesItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ListCasesItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (ListCasesItem)((ListCasesItem.Builder)ListCasesItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getTotal() {
            return this.total;
        }

        public final void setTotal(Long total) {
            this.total = total;
        }

        @Override
        public final Builder total(Long total) {
            this.total = total;
            return this;
        }

        @Override
        public ListCasesResponse build() {
            return new ListCasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityIrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCasesResponse> {
        public Builder nextToken(String var1);

        public Builder items(Collection<ListCasesItem> var1);

        public Builder items(ListCasesItem ... var1);

        public Builder items(Consumer<ListCasesItem.Builder> ... var1);

        public Builder total(Long var1);
    }
}

