/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClosureCode {
    INVESTIGATION_COMPLETED("Investigation Completed"),
    NOT_RESOLVED("Not Resolved"),
    FALSE_POSITIVE("False Positive"),
    DUPLICATE("Duplicate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClosureCode> VALUE_MAP;
    private final String value;

    private ClosureCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClosureCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClosureCode> knownValues() {
        EnumSet<ClosureCode> knownValues = EnumSet.allOf(ClosureCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClosureCode.class, ClosureCode::toString);
    }
}

