/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityir.model.ResolverType;
import software.amazon.awssdk.services.securityir.model.SecurityIrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResolverTypeRequest
extends SecurityIrRequest
implements ToCopyableBuilder<Builder, UpdateResolverTypeRequest> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseId").getter(UpdateResolverTypeRequest.getter(UpdateResolverTypeRequest::caseId)).setter(UpdateResolverTypeRequest.setter(Builder::caseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("caseId").build()}).build();
    private static final SdkField<String> RESOLVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolverType").getter(UpdateResolverTypeRequest.getter(UpdateResolverTypeRequest::resolverTypeAsString)).setter(UpdateResolverTypeRequest.setter(Builder::resolverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, RESOLVER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateResolverTypeRequest.memberNameToFieldInitializer();
    private final String caseId;
    private final String resolverType;

    private UpdateResolverTypeRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.resolverType = builder.resolverType;
    }

    public final String caseId() {
        return this.caseId;
    }

    public final ResolverType resolverType() {
        return ResolverType.fromValue(this.resolverType);
    }

    public final String resolverTypeAsString() {
        return this.resolverType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverTypeRequest)) {
            return false;
        }
        UpdateResolverTypeRequest other = (UpdateResolverTypeRequest)((Object)obj);
        return Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.resolverTypeAsString(), other.resolverTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResolverTypeRequest").add("CaseId", (Object)this.caseId()).add("ResolverType", (Object)this.resolverTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseId": {
                return Optional.ofNullable(clazz.cast(this.caseId()));
            }
            case "resolverType": {
                return Optional.ofNullable(clazz.cast(this.resolverTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("resolverType", RESOLVER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverTypeRequest, T> g) {
        return obj -> g.apply((UpdateResolverTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrRequest.BuilderImpl
    implements Builder {
        private String caseId;
        private String resolverType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverTypeRequest model) {
            super(model);
            this.caseId(model.caseId);
            this.resolverType(model.resolverType);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getResolverType() {
            return this.resolverType;
        }

        public final void setResolverType(String resolverType) {
            this.resolverType = resolverType;
        }

        @Override
        public final Builder resolverType(String resolverType) {
            this.resolverType = resolverType;
            return this;
        }

        @Override
        public final Builder resolverType(ResolverType resolverType) {
            this.resolverType(resolverType == null ? null : resolverType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResolverTypeRequest build() {
            return new UpdateResolverTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityIrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResolverTypeRequest> {
        public Builder caseId(String var1);

        public Builder resolverType(String var1);

        public Builder resolverType(ResolverType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

