/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CaseStatus {
    SUBMITTED("Submitted"),
    ACKNOWLEDGED("Acknowledged"),
    DETECTION_AND_ANALYSIS("Detection and Analysis"),
    CONTAINMENT_ERADICATION_AND_RECOVERY("Containment, Eradication and Recovery"),
    POST_INCIDENT_ACTIVITIES("Post-incident Activities"),
    READY_TO_CLOSE("Ready to Close"),
    CLOSED("Closed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CaseStatus> VALUE_MAP;
    private final String value;

    private CaseStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CaseStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CaseStatus> knownValues() {
        EnumSet<CaseStatus> knownValues = EnumSet.allOf(CaseStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CaseStatus.class, CaseStatus::toString);
    }
}

