/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ProviderUpdateConfiguration;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectorV2Request
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, UpdateConnectorV2Request> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorId").getter(UpdateConnectorV2Request.getter(UpdateConnectorV2Request::connectorId)).setter(UpdateConnectorV2Request.setter(Builder::connectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("ConnectorId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateConnectorV2Request.getter(UpdateConnectorV2Request::description)).setter(UpdateConnectorV2Request.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ProviderUpdateConfiguration> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Provider").getter(UpdateConnectorV2Request.getter(UpdateConnectorV2Request::provider)).setter(UpdateConnectorV2Request.setter(Builder::provider)).constructor(ProviderUpdateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD, DESCRIPTION_FIELD, PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConnectorV2Request.memberNameToFieldInitializer();
    private final String connectorId;
    private final String description;
    private final ProviderUpdateConfiguration provider;

    private UpdateConnectorV2Request(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.description = builder.description;
        this.provider = builder.provider;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final String description() {
        return this.description;
    }

    public final ProviderUpdateConfiguration provider() {
        return this.provider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorV2Request)) {
            return false;
        }
        UpdateConnectorV2Request other = (UpdateConnectorV2Request)((Object)obj);
        return Objects.equals(this.connectorId(), other.connectorId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.provider(), other.provider());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectorV2Request").add("ConnectorId", (Object)this.connectorId()).add("Description", (Object)this.description()).add("Provider", (Object)this.provider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Provider", PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorV2Request, T> g) {
        return obj -> g.apply((UpdateConnectorV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private String connectorId;
        private String description;
        private ProviderUpdateConfiguration provider;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorV2Request model) {
            super(model);
            this.connectorId(model.connectorId);
            this.description(model.description);
            this.provider(model.provider);
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ProviderUpdateConfiguration.Builder getProvider() {
            return this.provider != null ? this.provider.toBuilder() : null;
        }

        public final void setProvider(ProviderUpdateConfiguration.BuilderImpl provider) {
            this.provider = provider != null ? provider.build() : null;
        }

        @Override
        public final Builder provider(ProviderUpdateConfiguration provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectorV2Request build() {
            return new UpdateConnectorV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConnectorV2Request> {
        public Builder connectorId(String var1);

        public Builder description(String var1);

        public Builder provider(ProviderUpdateConfiguration var1);

        default public Builder provider(Consumer<ProviderUpdateConfiguration.Builder> provider) {
            return this.provider((ProviderUpdateConfiguration)((ProviderUpdateConfiguration.Builder)ProviderUpdateConfiguration.builder().applyMutation(provider)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

