/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesActionListV2Copier;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesActionV2;
import software.amazon.awssdk.services.securityhub.model.Criteria;
import software.amazon.awssdk.services.securityhub.model.RuleStatusV2;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAutomationRuleV2Request
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, UpdateAutomationRuleV2Request> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateAutomationRuleV2Request.getter(UpdateAutomationRuleV2Request::identifier)).setter(UpdateAutomationRuleV2Request.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> RULE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleStatus").getter(UpdateAutomationRuleV2Request.getter(UpdateAutomationRuleV2Request::ruleStatusAsString)).setter(UpdateAutomationRuleV2Request.setter(Builder::ruleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleStatus").build()}).build();
    private static final SdkField<Float> RULE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("RuleOrder").getter(UpdateAutomationRuleV2Request.getter(UpdateAutomationRuleV2Request::ruleOrder)).setter(UpdateAutomationRuleV2Request.setter(Builder::ruleOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateAutomationRuleV2Request.getter(UpdateAutomationRuleV2Request::description)).setter(UpdateAutomationRuleV2Request.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(UpdateAutomationRuleV2Request.getter(UpdateAutomationRuleV2Request::ruleName)).setter(UpdateAutomationRuleV2Request.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<Criteria> CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Criteria").getter(UpdateAutomationRuleV2Request.getter(UpdateAutomationRuleV2Request::criteria)).setter(UpdateAutomationRuleV2Request.setter(Builder::criteria)).constructor(Criteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criteria").build()}).build();
    private static final SdkField<List<AutomationRulesActionV2>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(UpdateAutomationRuleV2Request.getter(UpdateAutomationRuleV2Request::actions)).setter(UpdateAutomationRuleV2Request.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationRulesActionV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, RULE_STATUS_FIELD, RULE_ORDER_FIELD, DESCRIPTION_FIELD, RULE_NAME_FIELD, CRITERIA_FIELD, ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAutomationRuleV2Request.memberNameToFieldInitializer();
    private final String identifier;
    private final String ruleStatus;
    private final Float ruleOrder;
    private final String description;
    private final String ruleName;
    private final Criteria criteria;
    private final List<AutomationRulesActionV2> actions;

    private UpdateAutomationRuleV2Request(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.ruleStatus = builder.ruleStatus;
        this.ruleOrder = builder.ruleOrder;
        this.description = builder.description;
        this.ruleName = builder.ruleName;
        this.criteria = builder.criteria;
        this.actions = builder.actions;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final RuleStatusV2 ruleStatus() {
        return RuleStatusV2.fromValue(this.ruleStatus);
    }

    public final String ruleStatusAsString() {
        return this.ruleStatus;
    }

    public final Float ruleOrder() {
        return this.ruleOrder;
    }

    public final String description() {
        return this.description;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final Criteria criteria() {
        return this.criteria;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<AutomationRulesActionV2> actions() {
        return this.actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.criteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomationRuleV2Request)) {
            return false;
        }
        UpdateAutomationRuleV2Request other = (UpdateAutomationRuleV2Request)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.ruleStatusAsString(), other.ruleStatusAsString()) && Objects.equals(this.ruleOrder(), other.ruleOrder()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.criteria(), other.criteria()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAutomationRuleV2Request").add("Identifier", (Object)this.identifier()).add("RuleStatus", (Object)this.ruleStatusAsString()).add("RuleOrder", (Object)this.ruleOrder()).add("Description", (Object)this.description()).add("RuleName", (Object)this.ruleName()).add("Criteria", (Object)this.criteria()).add("Actions", this.hasActions() ? this.actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "RuleStatus": {
                return Optional.ofNullable(clazz.cast(this.ruleStatusAsString()));
            }
            case "RuleOrder": {
                return Optional.ofNullable(clazz.cast(this.ruleOrder()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "Criteria": {
                return Optional.ofNullable(clazz.cast(this.criteria()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("RuleStatus", RULE_STATUS_FIELD);
        map.put("RuleOrder", RULE_ORDER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("Criteria", CRITERIA_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomationRuleV2Request, T> g) {
        return obj -> g.apply((UpdateAutomationRuleV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String ruleStatus;
        private Float ruleOrder;
        private String description;
        private String ruleName;
        private Criteria criteria;
        private List<AutomationRulesActionV2> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomationRuleV2Request model) {
            super(model);
            this.identifier(model.identifier);
            this.ruleStatus(model.ruleStatus);
            this.ruleOrder(model.ruleOrder);
            this.description(model.description);
            this.ruleName(model.ruleName);
            this.criteria(model.criteria);
            this.actions(model.actions);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getRuleStatus() {
            return this.ruleStatus;
        }

        public final void setRuleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
        }

        @Override
        public final Builder ruleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        @Override
        public final Builder ruleStatus(RuleStatusV2 ruleStatus) {
            this.ruleStatus(ruleStatus == null ? null : ruleStatus.toString());
            return this;
        }

        public final Float getRuleOrder() {
            return this.ruleOrder;
        }

        public final void setRuleOrder(Float ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(Float ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final Criteria.Builder getCriteria() {
            return this.criteria != null ? this.criteria.toBuilder() : null;
        }

        public final void setCriteria(Criteria.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(Criteria criteria) {
            this.criteria = criteria;
            return this;
        }

        public final List<AutomationRulesActionV2.Builder> getActions() {
            List<AutomationRulesActionV2.Builder> result = AutomationRulesActionListV2Copier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<AutomationRulesActionV2.BuilderImpl> actions) {
            this.actions = AutomationRulesActionListV2Copier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<AutomationRulesActionV2> actions) {
            this.actions = AutomationRulesActionListV2Copier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(AutomationRulesActionV2 ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<AutomationRulesActionV2.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (AutomationRulesActionV2)((AutomationRulesActionV2.Builder)AutomationRulesActionV2.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutomationRuleV2Request build() {
            return new UpdateAutomationRuleV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAutomationRuleV2Request> {
        public Builder identifier(String var1);

        public Builder ruleStatus(String var1);

        public Builder ruleStatus(RuleStatusV2 var1);

        public Builder ruleOrder(Float var1);

        public Builder description(String var1);

        public Builder ruleName(String var1);

        public Builder criteria(Criteria var1);

        default public Builder criteria(Consumer<Criteria.Builder> criteria) {
            return this.criteria((Criteria)((Criteria.Builder)Criteria.builder().applyMutation(criteria)).build());
        }

        public Builder actions(Collection<AutomationRulesActionV2> var1);

        public Builder actions(AutomationRulesActionV2 ... var1);

        public Builder actions(Consumer<AutomationRulesActionV2.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

