/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ResourceGroupByField;
import software.amazon.awssdk.services.securityhub.model.ResourcesFilters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceGroupByRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceGroupByRule> {
    private static final SdkField<String> GROUP_BY_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupByField").getter(ResourceGroupByRule.getter(ResourceGroupByRule::groupByFieldAsString)).setter(ResourceGroupByRule.setter(Builder::groupByField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByField").build()}).build();
    private static final SdkField<ResourcesFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(ResourceGroupByRule.getter(ResourceGroupByRule::filters)).setter(ResourceGroupByRule.setter(Builder::filters)).constructor(ResourcesFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_FIELD_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceGroupByRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupByField;
    private final ResourcesFilters filters;

    private ResourceGroupByRule(BuilderImpl builder) {
        this.groupByField = builder.groupByField;
        this.filters = builder.filters;
    }

    public final ResourceGroupByField groupByField() {
        return ResourceGroupByField.fromValue(this.groupByField);
    }

    public final String groupByFieldAsString() {
        return this.groupByField;
    }

    public final ResourcesFilters filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByFieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceGroupByRule)) {
            return false;
        }
        ResourceGroupByRule other = (ResourceGroupByRule)obj;
        return Objects.equals(this.groupByFieldAsString(), other.groupByFieldAsString()) && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceGroupByRule").add("GroupByField", (Object)this.groupByFieldAsString()).add("Filters", (Object)this.filters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupByField": {
                return Optional.ofNullable(clazz.cast(this.groupByFieldAsString()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GroupByField", GROUP_BY_FIELD_FIELD);
        map.put("Filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceGroupByRule, T> g) {
        return obj -> g.apply((ResourceGroupByRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupByField;
        private ResourcesFilters filters;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceGroupByRule model) {
            this.groupByField(model.groupByField);
            this.filters(model.filters);
        }

        public final String getGroupByField() {
            return this.groupByField;
        }

        public final void setGroupByField(String groupByField) {
            this.groupByField = groupByField;
        }

        @Override
        public final Builder groupByField(String groupByField) {
            this.groupByField = groupByField;
            return this;
        }

        @Override
        public final Builder groupByField(ResourceGroupByField groupByField) {
            this.groupByField(groupByField == null ? null : groupByField.toString());
            return this;
        }

        public final ResourcesFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(ResourcesFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ResourcesFilters filters) {
            this.filters = filters;
            return this;
        }

        public ResourceGroupByRule build() {
            return new ResourceGroupByRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceGroupByRule> {
        public Builder groupByField(String var1);

        public Builder groupByField(ResourceGroupByField var1);

        public Builder filters(ResourcesFilters var1);

        default public Builder filters(Consumer<ResourcesFilters.Builder> filters) {
            return this.filters((ResourcesFilters)((ResourcesFilters.Builder)ResourcesFilters.builder().applyMutation(filters)).build());
        }
    }
}

